"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointCustomAssetsExtension = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/fleet-plugin/public");
var _kibana = require("../../../../../common/lib/kibana");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_custom_assets_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EndpointCustomAssetsExtension = () => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const views = [{
    name: _i18n.i18n.translate('xpack.securitySolution.fleetIntegration.assets.name', {
      defaultMessage: 'Hosts'
    }),
    url: http.basePath.prepend(`${_constants.APP_PATH}/administration/endpoints`),
    description: _i18n.i18n.translate('xpack.securitySolution.fleetIntegration.assets.description', {
      defaultMessage: 'View endpoints in Security app'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_public.CustomAssetsAccordion, {
    views: views,
    initialIsOpen: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 10
    }
  });
};
exports.EndpointCustomAssetsExtension = EndpointCustomAssetsExtension;