"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReputationService = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _kibana = require("../../../../../../../../../common/lib/kibana");
var _use_test_id_generator = require("../../../../../../../../hooks/use_test_id_generator");
var _setting_card = require("../../../setting_card");
var _types = require("../../../../../../../../../../common/endpoint/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/protection_settings_card/components/reputation_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReputationService = exports.ReputationService = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode,
  protection,
  'data-test-subj': dataTestSubj
}) => {
  var _cloud$isCloudEnabled;
  const isEditMode = mode === 'edit';
  const {
    cloud
  } = (0, _kibana.useKibana)().services;
  const isCloud = (_cloud$isCloudEnabled = cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) !== null && _cloud$isCloudEnabled !== void 0 ? _cloud$isCloudEnabled : false;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const protectionTurnedOn = policy.windows.behavior_protection.mode !== _types.ProtectionModes.off;
  const checkboxChecked = policy.windows.behavior_protection.reputation_service && protectionTurnedOn;
  const handleChange = (0, _react.useCallback)(event => {
    const newPayload = (0, _lodash.cloneDeep)(policy);
    newPayload.windows.behavior_protection.reputation_service = event.target.checked;
    newPayload.mac.behavior_protection.reputation_service = event.target.checked;
    newPayload.linux.behavior_protection.reputation_service = event.target.checked;
    onChange({
      isValid: true,
      updatedPolicy: newPayload
    });
  }, [policy, onChange]);
  if (!isCloud) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('label'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyDetailsConfig.reputationService",
    defaultMessage: "Reputation service",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('tooltipIcon'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    "data-test-subj": getTestId('tooltip'),
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyDetailsConfig.reputationServiceTooltip",
      defaultMessage: "This option enables/disables the Reputation Service feature in Endpoint. When the option is ON, Endpoint will reach out to a Cloud API for additional detection coverage. When it's OFF, Endpoint will not reach out to the Cloud API, resulting in reduced efficacy.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": getTestId('checkbox'),
    id: `${protection}ReputationServiceCheckbox}`,
    onChange: handleChange,
    checked: checkboxChecked,
    disabled: !protectionTurnedOn || !isEditMode,
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetail.reputationService', {
      defaultMessage: 'Reputation service'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }));
});
ReputationService.displayName = 'ReputationService';