"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionUpdatesBottomBar = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_navigate_to_app_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _common = require("../../../../../../../common");
var _routing = require("../../../../../common/routing");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/protection_updates/components/protection_updates_bottom_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProtectionUpdatesBottomBar = exports.ProtectionUpdatesBottomBar = /*#__PURE__*/_react.default.memo(({
  isUpdating,
  onSave,
  saveButtonDisabled
}) => {
  const {
    state: locationRouteState
  } = (0, _reactRouterDom.useLocation)();
  const [routeState, setRouteState] = (0, _react.useState)();
  const routingOnCancelNavigateTo = routeState === null || routeState === void 0 ? void 0 : routeState.onCancelNavigateTo;
  (0, _react.useEffect)(() => {
    if (!routeState && locationRouteState) {
      setRouteState(locationRouteState);
    }
  }, [locationRouteState, routeState]);
  const navigateToAppArguments = (0, _react.useMemo)(() => {
    if (routingOnCancelNavigateTo) {
      return routingOnCancelNavigateTo;
    }
    return [_common.APP_UI_ID, {
      path: (0, _routing.getPoliciesPath)()
    }];
  }, [routingOnCancelNavigateTo]);
  const handleCancelOnClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(...navigateToAppArguments);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.BottomBar, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    onClick: handleCancelOnClick,
    "data-test-subj": "protectionUpdatesCancelButton",
    disabled: isUpdating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.protectionUpdates.cancel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: saveButtonDisabled,
    iconType: "save",
    "data-test-subj": "protectionUpdatesSaveButton",
    onClick: onSave,
    isLoading: isUpdating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.protectionUpdates.save",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  })))));
});
ProtectionUpdatesBottomBar.displayName = 'ProtectionUpdatesBottomBar';