"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionEntryInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _types = require("../../../../../../../common/endpoint/types");
var _translations = require("../../translations");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _path_placeholder = require("../../../../../../../common/utils/path_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/trusted_apps/view/components/condition_entry_input/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConditionEntryCell = /*#__PURE__*/(0, _react.memo)(({
  showLabel,
  label = '',
  children
}) => {
  return showLabel ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
ConditionEntryCell.displayName = 'ConditionEntryCell';
// adding a style prop on EuiFlexGroup works only partially
// and for some odd reason garbles up gridTemplateAreas entry
const InputGroup = _styled.default.div`
  display: grid;
  grid-template-columns: 25% 25% 45% 5%;
  grid-template-areas: 'field operator value remove';
`;
const InputItem = _styled.default.div`
  grid-area: ${({
  gridArea
}) => gridArea};
  align-self: center;
  margin-right: ${props => props.theme.euiTheme.size.s};
  vertical-align: baseline;
`;
const operatorOptions = Object.keys(_types.OperatorFieldIds).map(value => ({
  dropdownDisplay: _translations.OPERATOR_TITLES[value],
  inputDisplay: _translations.OPERATOR_TITLES[value],
  value: value === 'matches' ? 'wildcard' : 'match'
}));
const ConditionEntryInput = exports.ConditionEntryInput = /*#__PURE__*/(0, _react.memo)(({
  os,
  entry,
  showLabels = false,
  onRemove,
  onChange,
  isRemoveDisabled = false,
  onVisited,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [isVisited, setIsVisited] = (0, _react.useState)(false);
  const handleVisited = (0, _react.useCallback)(() => {
    onVisited === null || onVisited === void 0 ? void 0 : onVisited(entry);
    if (!isVisited) {
      setIsVisited(true);
    }
  }, [entry, isVisited, onVisited]);
  const fieldOptions = (0, _react.useMemo)(() => {
    const getDropdownDisplay = field => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.CONDITION_FIELD_TITLE[field], /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }, _translations.CONDITION_FIELD_DESCRIPTION[field]));
    return [{
      dropdownDisplay: getDropdownDisplay(_securitysolutionUtils.ConditionEntryField.HASH),
      inputDisplay: _translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.HASH],
      value: _securitysolutionUtils.ConditionEntryField.HASH,
      'data-test-subj': getTestId(`field-type-${_translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.HASH]}`)
    }, {
      dropdownDisplay: getDropdownDisplay(_securitysolutionUtils.ConditionEntryField.PATH),
      inputDisplay: _translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.PATH],
      value: _securitysolutionUtils.ConditionEntryField.PATH,
      'data-test-subj': getTestId(`field-type-${_translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.PATH]}`)
    }, ...(os === _securitysolutionUtils.OperatingSystem.WINDOWS ? [{
      dropdownDisplay: getDropdownDisplay(_securitysolutionUtils.ConditionEntryField.SIGNER),
      inputDisplay: _translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.SIGNER],
      value: _securitysolutionUtils.ConditionEntryField.SIGNER,
      'data-test-subj': getTestId(`field-type-${_translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.SIGNER]}`)
    }] : []), ...(os === _securitysolutionUtils.OperatingSystem.MAC ? [{
      dropdownDisplay: getDropdownDisplay(_securitysolutionUtils.ConditionEntryField.SIGNER_MAC),
      inputDisplay: _translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.SIGNER_MAC],
      value: _securitysolutionUtils.ConditionEntryField.SIGNER_MAC,
      'data-test-subj': getTestId(`field-type-${_translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.SIGNER_MAC]}`)
    }] : [])];
  }, [getTestId, os]);
  const handleValueUpdate = (0, _react.useCallback)(ev => onChange({
    ...entry,
    value: ev.target.value
  }, entry), [entry, onChange]);
  const handleFieldUpdate = (0, _react.useCallback)(newField => {
    onChange({
      ...entry,
      field: newField
    }, entry);
    if (entry.value) {
      handleVisited();
    }
  }, [handleVisited, entry, onChange]);
  const handleOperatorUpdate = (0, _react.useCallback)(newOperator => onChange({
    ...entry,
    type: newOperator
  }, entry), [entry, onChange]);
  const handleRemoveClick = (0, _react.useCallback)(() => onRemove(entry), [entry, onRemove]);
  const handleValueOnBlur = (0, _react.useCallback)(() => {
    handleVisited();
  }, [handleVisited]);
  return /*#__PURE__*/_react.default.createElement(InputGroup, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: _translations.ENTRY_PROPERTY_TITLES.field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: fieldOptions,
    valueOfSelected: entry.field,
    onChange: handleFieldUpdate,
    "data-test-subj": getTestId('field'),
    "aria-label": _translations.ENTRY_PROPERTY_TITLES.field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "operator",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: _translations.ENTRY_PROPERTY_TITLES.operator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }, entry.field === _securitysolutionUtils.ConditionEntryField.PATH ? /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: operatorOptions,
    onChange: handleOperatorUpdate,
    valueOfSelected: entry.type,
    "data-test-subj": getTestId('operator'),
    "aria-label": _translations.ENTRY_PROPERTY_TITLES.operator,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "operator",
    value: _translations.OPERATOR_TITLES.is,
    "data-test-subj": getTestId('operator'),
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: _translations.ENTRY_PROPERTY_TITLES.value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "value",
    value: entry.value,
    placeholder: (0, _path_placeholder.getPlaceholderTextByOSType)({
      os,
      field: entry.field,
      type: entry.type
    }),
    fullWidth: true,
    required: isVisited,
    onChange: handleValueUpdate,
    onBlur: handleValueOnBlur,
    "data-test-subj": getTestId('value'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "remove",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: '\u00A0',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    onClick: handleRemoveClick,
    isDisabled: isRemoveDisabled,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.removeLabel', {
      defaultMessage: 'Remove Entry'
    }),
    "data-test-subj": getTestId('remove'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 13
    }
  }))));
});
ConditionEntryInput.displayName = 'ConditionEntryInput';