"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrustedDevicesList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _api_client = require("../service/api_client");
var _form = require("./components/form");
var _kibana = require("../../../../common/lib/kibana");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _constants = require("../constants");
var _artifacts_docs_link = require("./components/artifacts_docs_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/trusted_devices/view/trusted_devices_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TRUSTED_DEVICES_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.pageTitle', {
    defaultMessage: 'Trusted devices'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.pageAboutInfo', {
    defaultMessage: 'Allow a specific external device to connect to your endpoints, even when Device Control is enabled.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.pageAddButtonTitle', {
    defaultMessage: 'Add trusted device'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {trusted device} other {trusted devices}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.cardActionEditLabel', {
    defaultMessage: 'Edit trusted device'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.cardActionDeleteLabel', {
    defaultMessage: 'Remove from trusted devices list'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.flyoutCreateTitle', {
    defaultMessage: 'Add trusted device'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.flyoutEditTitle', {
    defaultMessage: 'Edit trusted device'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add trusted device'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your trusted devices list.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedDevices.list.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.trustedDevices}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedDevices.list.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "trusted devices documentation.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.deleteActionSuccess', {
    defaultMessage: '"{itemName}" has been removed from the trusted devices list',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no trusted devices to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.emptyStateTitle', {
    defaultMessage: 'Add your first trusted device'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.emptyStateInfo', {
    defaultMessage: 'Add trusted devices to allow specific external devices to connect to your endpoints even when Device Control is enabled.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add trusted device'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.trustedDevices.list.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, value'
  })
};
const TrustedDevicesList = exports.TrustedDevicesList = /*#__PURE__*/(0, _react.memo)(props => {
  const http = (0, _kibana.useHttp)();
  const isTrustedDevicesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('trustedDevices');
  const trustedDevicesListApiClient = _api_client.TrustedDevicesApiClient.getInstance(http);
  const {
    canWriteTrustedDevices
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  if (!isTrustedDevicesEnabled) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: trustedDevicesListApiClient,
    ArtifactFormComponent: _form.TrustedDevicesForm,
    labels: TRUSTED_DEVICES_PAGE_LABELS,
    "data-test-subj": "trustedDevicesList",
    searchableFields: _constants.SEARCHABLE_FIELDS,
    secondaryPageInfo: /*#__PURE__*/_react.default.createElement(_artifacts_docs_link.TrustedDevicesArtifactsDocsLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 26
      }
    }),
    allowCardDeleteAction: canWriteTrustedDevices,
    allowCardEditAction: canWriteTrustedDevices,
    allowCardCreateAction: canWriteTrustedDevices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 5
    }
  });
});
TrustedDevicesList.displayName = 'TrustedDevicesList';