"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreatedByFilterDropdown = exports.CREATED_BY = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _use_license = require("../../common/hooks/use_license");
var _use_upselling = require("../../common/hooks/use_upselling");
var _test_ids = require("./test_ids");
var _use_suggest_users = require("../../common/components/user_profiles/use_suggest_users");
var _ = require("..");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/created_by_filter_dropdown.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CREATED_BY = exports.CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.notes.createdByDropdownLabel', {
  defaultMessage: 'Created by'
});
const CreatedByFilterDropdown = exports.CreatedByFilterDropdown = /*#__PURE__*/_react.default.memo(() => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const upsellingMessage = (0, _use_upselling.useUpsellingMessage)('note_management_user_filter');
  const {
    isLoading,
    data
  } = (0, _use_suggest_users.useSuggestUsers)({
    searchTerm: '',
    enabled: isPlatinumPlus
  });
  const users = (0, _react.useMemo)(() => (data || []).map(userProfile => ({
    id: userProfile.uid,
    label: userProfile.user.full_name || userProfile.user.email || userProfile.user.username
  })), [data]);
  const [selectedUser, setSelectedUser] = (0, _react.useState)();
  const onChange = (0, _react.useCallback)(user => {
    setSelectedUser(user);
    dispatch((0, _.userFilterCreatedBy)(user.length > 0 ? user[0].id : ''));
  }, [dispatch]);
  const dropdown = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    prepend: CREATED_BY,
    "aria-label": CREATED_BY,
    singleSelection: {
      asPlainText: true
    },
    options: users,
    selectedOptions: selectedUser,
    onChange: onChange,
    isLoading: isPlatinumPlus && isLoading,
    isDisabled: !isPlatinumPlus,
    "data-test-subj": _test_ids.CREATED_BY_SELECT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), [isLoading, isPlatinumPlus, onChange, selectedUser, users]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isPlatinumPlus ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dropdown) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: upsellingMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, dropdown));
});
CreatedByFilterDropdown.displayName = 'CreatedByFilterDropdown';