"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticAIFeatureMessage = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("@kbn/elastic-assistant/impl/tour/elastic_llm/translations");
var _kibana = require("../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/assistant/ai_feature_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ElasticAIFeatureMessage = exports.ElasticAIFeatureMessage = /*#__PURE__*/_react.default.memo(() => {
  const {
    docLinks: {
      links: {
        securitySolution: {
          elasticAiFeatures: ELASTIC_AI_FEATURES_LINK,
          thirdPartyLlmProviders: THIRD_PARTY_LLM_LINK
        },
        observability: {
          elasticManagedLlmUsageCost: ELASTIC_LLM_USAGE_COST_LINK
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.onboarding.assistantCard.elasticAIFeature.content",
    defaultMessage: "{elasticAiFeatures} require an LLM connector. You can use the Elastic Managed LLM connector, which is available by default, or {thirdParty}. Learn more about Elastic Managed LLM connector's {usageCost}.",
    values: {
      elasticAiFeatures: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ELASTIC_AI_FEATURES_LINK,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 11
        }
      }, _translations.ELASTIC_LLM_AI_FEATURES),
      usageCost: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: ELASTIC_LLM_USAGE_COST_LINK,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }, _translations.ELASTIC_LLM_USAGE_COSTS),
      thirdParty: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: THIRD_PARTY_LLM_LINK,
        target: "_blank",
        rel: "noopener noreferrer",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 11
        }
      }, _translations.ELASTIC_LLM_THIRD_PARTY)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
});
ElasticAIFeatureMessage.displayName = 'ElasticAIFeatureMessage';