"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AttackDiscoveryCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _links = require("../../../../../common/components/links");
var _constants = require("../../../../constants");
var _card_content_asset_panel = require("../common/card_content_asset_panel");
var _card_callout = require("../common/card_callout");
var _attack_discovery = _interopRequireDefault(require("./images/attack_discovery.png"));
var i18n = _interopRequireWildcard(require("./translations"));
var _types = require("../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/attack_discovery/attack_discovery_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AttackDiscoveryCard = exports.AttackDiscoveryCard = /*#__PURE__*/_react.default.memo(({
  isCardComplete,
  setExpandedCardId,
  setComplete
}) => {
  const isIntegrationsCardComplete = (0, _react.useMemo)(() => isCardComplete(_constants.OnboardingCardId.integrations), [isCardComplete]);
  const expandIntegrationsCard = (0, _react.useCallback)(() => {
    setExpandedCardId(_constants.OnboardingCardId.integrations, {
      scroll: true
    });
  }, [setExpandedCardId]);
  const asset = (0, _react.useMemo)(() => ({
    type: _types.CardAssetType.image,
    source: _attack_discovery.default,
    alt: i18n.ATTACK_DISCOVERY_CARD_TITLE
  }), []);
  return /*#__PURE__*/_react.default.createElement(_card_content_asset_panel.OnboardingCardContentAssetPanel, {
    asset: asset,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl",
    justifyContent: "flexStart",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "attackDiscoveryCardDescription",
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }, i18n.ATTACK_DISCOVERY_CARD_DESCRIPTION), !isIntegrationsCardComplete && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_card_callout.CardCallOut, {
    color: "primary",
    icon: "info",
    text: i18n.ATTACK_DISCOVERY_CARD_CALLOUT_INTEGRATIONS_TEXT,
    action: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: expandIntegrationsCard,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 25
      }
    }, i18n.ATTACK_DISCOVERY_CARD_CALLOUT_INTEGRATIONS_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      color: "primary",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 27
      }
    })))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "attackDiscoveryCardButton",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    onClick: () => setComplete(true),
    deepLinkId: _securitySolutionNavigation.SecurityPageName.attackDiscovery,
    fill: true,
    isDisabled: !isIntegrationsCardComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  }, i18n.ATTACK_DISCOVERY_CARD_START_ATTACK_DISCOVERY_BUTTON))));
});
AttackDiscoveryCard.displayName = 'AttackDiscoveryCard';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AttackDiscoveryCard;