"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardSelectorList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _card_selector_list = require("./card_selector_list.styles");
var _onboarding_card_panel = require("../../onboarding_card_panel.styles");
var _onboarding_context = require("../../../onboarding_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/common/card_selector_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const scrollToSelectedItem = cardId => {
  setTimeout(() => {
    const element = document.getElementById(`selector-${cardId}`);
    if (element) {
      element.scrollIntoView({
        behavior: 'smooth',
        block: 'nearest'
      });
    }
  }, _onboarding_card_panel.HEIGHT_ANIMATION_DURATION + 250);
};
const CardSelectorList = exports.CardSelectorList = /*#__PURE__*/_react.default.memo(({
  items,
  onSelect,
  selectedItem,
  title,
  cardId
}) => {
  const {
    telemetry
  } = (0, _onboarding_context.useOnboardingContext)();
  const styles = (0, _card_selector_list.useCardSelectorListStyles)();
  (0, _react.useEffect)(() => {
    scrollToSelectedItem(selectedItem.id);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleSelect = (0, _react.useCallback)(item => {
    onSelect(item);
    telemetry.reportCardSelectorClicked(cardId, item.id);
  }, [cardId, onSelect, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "cardSelectorList",
    direction: "column",
    gutterSize: "s",
    className: styles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "cardSelectorTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    id: "scroll-container",
    className: "cardSelectorContent",
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `key-${item.id}`,
    id: `selector-${item.id}`,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": `cardSelectorItem-${item.id}`,
    className: selectedItem.id === item.id ? 'selectedCardPanelItem' : '',
    color: selectedItem.id === item.id ? 'subdued' : 'plain',
    element: "button",
    onClick: () => handleSelect(item),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 21
    }
  }, item.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 19
    }
  }, item.description)))))));
});
CardSelectorList.displayName = 'CardSelectorList';