"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _kibana = require("../../../../../../../common/lib/kibana");
var _links = require("../../../../../../../common/components/links");
var _card_callout = require("../../card_callout");
var _constants = require("../constants");
var _integration_context = require("../../../../../../../common/lib/integrations/hooks/integration_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/common/integrations/callouts/endpoint_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointCallout = exports.EndpointCallout = /*#__PURE__*/_react.default.memo(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const {
    telemetry: {
      reportLinkClick
    }
  } = (0, _integration_context.useIntegrationContext)();
  const onClick = (0, _react.useCallback)(() => {
    reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(_constants.TELEMETRY_ENDPOINT_LEARN_MORE);
  }, [reportLinkClick]);
  return /*#__PURE__*/_react.default.createElement(_card_callout.CardCallOut, {
    color: "danger",
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.onboarding.integrationsCard.callout.endpointLabel",
      defaultMessage: `{icon} {new} {text} {link}`,
      values: {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "cheer",
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 19
          }
        }),
        new: /*#__PURE__*/_react.default.createElement("b", {
          css: (0, _react2.css)`
                  font-weight: ${euiTheme.font.weight.bold};
                `,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.callout.endpointNewLabel",
          defaultMessage: "NEW",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 17
          }
        })),
        text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.callout.endpointText",
          defaultMessage: "Orchestrate response across endpoint vendors with bidirectional integrations",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 15
          }
        }),
        link: /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
          href: docLinks.links.securitySolution.responseActions,
          "data-test-subj": "endpointLearnMoreLink",
          external: true,
          target: "_blank",
          onClick: onClick,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.callout.button.endpointLearnMoreLink",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 17
          }
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  });
});
EndpointCallout.displayName = 'EndpointCallout';