"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageIntegrationsCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _links = require("../../../../../../../common/components/links");
var _card_callout = require("../../card_callout");
var _use_add_integrations_url = require("../../../../../../../common/hooks/use_add_integrations_url");
var _constants = require("../constants");
var _integration_context = require("../../../../../../../common/lib/integrations/hooks/integration_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/common/integrations/callouts/manage_integrations_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManageIntegrationsCallout = exports.ManageIntegrationsCallout = /*#__PURE__*/_react.default.memo(({
  activeIntegrationsCount
}) => {
  const {
    href: integrationUrl,
    onClick: onAddIntegrationClicked
  } = (0, _use_add_integrations_url.useAddIntegrationsUrl)();
  const {
    telemetry: {
      reportLinkClick
    }
  } = (0, _integration_context.useIntegrationContext)();
  const onClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(_constants.TELEMETRY_MANAGE_INTEGRATIONS);
    onAddIntegrationClicked(e);
  }, [onAddIntegrationClicked, reportLinkClick]);
  if (!activeIntegrationsCount) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_card_callout.CardCallOut, {
    color: "primary",
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "integrationsCompleteText",
      id: "xpack.securitySolution.onboarding.integrationsCard.callout.completeText",
      defaultMessage: "{count} {count, plural, one {integration has} other {integrations have}} been added",
      values: {
        count: activeIntegrationsCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 11
      }
    }),
    action: /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
      onClick: onClick,
      href: integrationUrl,
      "data-test-subj": "manageIntegrationsLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.onboarding.integrationsCard.button.completeLink",
      defaultMessage: "Manage integrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "arrowRight",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  });
});
ManageIntegrationsCallout.displayName = 'ManageIntegrationsCallout';