"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcererButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _use_colors = require("../use_colors");
var _components = require("../../../sourcerer/components");
var _model = require("../../../sourcerer/store/model");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _data_view_picker = require("../../../data_view_manager/components/data_view_picker");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/controls/sourcerer_selection.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const nodeLegendButtonTitle = _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.sourcererButtonTitle', {
  defaultMessage: 'Data View Selection'
});
const SourcererButton = exports.SourcererButton = /*#__PURE__*/(0, _react.memo)(({
  id,
  closePopover,
  setActivePopover,
  isOpen
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const setAsActivePopover = (0, _react.useCallback)(() => {
    setActivePopover('sourcererSelection');
  }, [setActivePopover]);
  const colorMap = (0, _use_colors.useColors)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_styles.StyledEuiButtonIcon, {
      "data-test-subj": "resolver:graph-controls:sourcerer-button",
      size: "m",
      title: nodeLegendButtonTitle,
      "aria-label": nodeLegendButtonTitle,
      onClick: setAsActivePopover,
      iconType: "indexSettings",
      $backgroundColor: colorMap.graphControlsBackground,
      $iconColor: colorMap.graphControls,
      $borderColor: colorMap.graphControlsBorderColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }),
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }, newDataViewPickerEnabled ? /*#__PURE__*/_react.default.createElement(_data_view_picker.DataViewPicker, {
    scope: _model.SourcererScopeName.analyzer,
    onClosePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_components.Sourcerer, {
    scope: _model.SourcererScopeName.analyzer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }));
});
SourcererButton.displayName = 'SourcererButton';