"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationDataInputFlyout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _migration_data_input_flyout_context = require("../../../common/components/migration_data_input_flyout_context");
var _upload_dashboards = require("./steps/upload_dashboards");
var _macros_data_input = require("./steps/macros/macros_data_input");
var _lookups_data_input = require("./steps/lookups/lookups_data_input");
var _constants2 = require("./steps/constants");
var _use_start_dashboard_migration_modal = require("../../hooks/use_start_dashboard_migration_modal");
var _use_start_migration = require("../../logic/use_start_migration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/data_input_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DASHBOARDS_MIGRATION_DATA_INPUT_FLYOUT_TITLE = 'dashboardsMigrationDataInputFlyoutTitle';
const DashboardMigrationDataInputFlyout = exports.DashboardMigrationDataInputFlyout = /*#__PURE__*/_react.default.memo(function DashboardMigrationDataInputFlyout({
  onClose,
  migrationStats,
  setFlyoutMigrationStats
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: DASHBOARDS_MIGRATION_DATA_INPUT_FLYOUT_TITLE
  });
  const {
    closeFlyout
  } = (0, _migration_data_input_flyout_context.useMigrationDataInputContext)();
  const [missingResourcesIndexed, setMissingResourcesIndexed] = (0, _react.useState)();
  const isRetry = (migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.status) === _constants.SiemMigrationTaskStatus.FINISHED;
  const [dataInputStep, setDataInputStep] = (0, _react.useState)(_constants2.DashboardUploadSteps.DashboardsUpload);
  const onMigrationCreated = (0, _react.useCallback)(createdMigrationStats => {
    setFlyoutMigrationStats(createdMigrationStats);
  }, [setFlyoutMigrationStats]);
  const onMissingResourcesFetched = (0, _react.useCallback)(missingResources => {
    const newMissingResourcesIndexed = missingResources.reduce((acc, {
      type,
      name
    }) => {
      if (type === 'macro') {
        acc.macros.push(name);
      } else if (type === 'lookup') {
        acc.lookups.push(name);
      }
      return acc;
    }, {
      macros: [],
      lookups: []
    });
    setMissingResourcesIndexed(newMissingResourcesIndexed);
    if (newMissingResourcesIndexed.macros.length) {
      setDataInputStep(_constants2.DashboardUploadSteps.MacrosUpload);
      return;
    }
    if (newMissingResourcesIndexed.lookups.length) {
      setDataInputStep(_constants2.DashboardUploadSteps.LookupsUpload);
      return;
    }
    setDataInputStep(_constants2.DashboardUploadSteps.End);
  }, []);
  const onAllLookupsCreated = (0, _react.useCallback)(() => {
    setDataInputStep(_constants2.DashboardUploadSteps.End);
  }, []);
  const {
    startMigration,
    isLoading: isStartLoading
  } = (0, _use_start_migration.useStartMigration)(onClose);
  const onStartMigrationWithSettings = (0, _react.useCallback)(settings => {
    if (migrationStats !== null && migrationStats !== void 0 && migrationStats.id) {
      startMigration(migrationStats.id, isRetry ? _constants.SiemMigrationRetryFilter.NOT_FULLY_TRANSLATED : undefined, settings);
    }
  }, [isRetry, migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id, startMigration]);
  const {
    modal: startMigrationModal,
    showModal: showStartMigrationModal
  } = (0, _use_start_dashboard_migration_modal.useStartDashboardsMigrationModal)({
    type: isRetry ? 'retry' : 'start',
    migrationStats,
    onStartMigrationWithSettings
  });
  const onTranslateButtonClick = (0, _react.useCallback)(() => {
    if (migrationStats !== null && migrationStats !== void 0 && migrationStats.id) {
      showStartMigrationModal();
    }
  }, [migrationStats === null || migrationStats === void 0 ? void 0 : migrationStats.id, showStartMigrationModal]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, startMigrationModal, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    onClose: closeFlyout,
    ownFocus: true,
    size: 850,
    maxWidth: 1200,
    minWidth: 500,
    "data-test-subj": "dashboardMigrationDataInputFlyout",
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    "aria-label": DASHBOARDS_MIGRATION_DATA_INPUT_FLYOUT_TITLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }, i18n.DATA_INPUT_FLYOUT_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_upload_dashboards.DashboardsUploadStep, {
    dataInputStep: dataInputStep,
    migrationStats: migrationStats,
    onMigrationCreated: onMigrationCreated,
    onMissingResourcesFetched: onMissingResourcesFetched,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_macros_data_input.MacrosDataInput, {
    dataInputStep: dataInputStep,
    missingMacros: missingResourcesIndexed === null || missingResourcesIndexed === void 0 ? void 0 : missingResourcesIndexed.macros,
    migrationStats: migrationStats,
    onMissingResourcesFetched: onMissingResourcesFetched,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_lookups_data_input.LookupsDataInput, {
    dataInputStep: dataInputStep,
    missingLookups: missingResourcesIndexed === null || missingResourcesIndexed === void 0 ? void 0 : missingResourcesIndexed.lookups,
    migrationStats: migrationStats,
    onAllLookupsCreated: onAllLookupsCreated,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "dataFlyoutCloseButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.dashboards.dataInputFlyout.closeButton",
    defaultMessage: "Close",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onTranslateButtonClick,
    disabled: !(migrationStats !== null && migrationStats !== void 0 && migrationStats.id),
    isLoading: isStartLoading,
    "data-test-subj": "startMigrationButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 17
    }
  }, isRetry ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.dashboards.dataInputFlyout.retryTranslateButton",
    defaultMessage: "Retry translation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.dashboards.dataInputFlyout.translateButton",
    defaultMessage: "Translate",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 21
    }
  })))))));
});