"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.raiseSuccessToast = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/service/notification/success_notification.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const raiseSuccessToast = (migrationStats, core) => {
  const toast = core.notifications.toasts.addSuccess({
    color: 'success',
    iconType: 'check',
    toastLifeTimeMs: 1000 * 60 * 30,
    // 30 minutes
    title: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboardsService.polling.successTitle', {
      defaultMessage: 'Dashboards translation complete.'
    }),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_securitySolutionNavigation.NavigationProvider, {
      core: core,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(SuccessToastContent, {
      migrationStats: migrationStats,
      dismissHandler: () => core.notifications.toasts.remove(toast),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    })), core)
  });
};
exports.raiseSuccessToast = raiseSuccessToast;
const SuccessToastContent = ({
  migrationStats,
  dismissHandler
}) => {
  const {
    navigateTo,
    getAppUrl
  } = (0, _securitySolutionNavigation.useNavigation)();
  const navParams = (0, _react.useMemo)(() => {
    return {
      deepLinkId: _securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards,
      path: migrationStats.id
    };
  }, [migrationStats.id]);
  const onClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateTo({
      deepLinkId: _securitySolutionNavigation.SecurityPageName.siemMigrationsDashboards,
      path: migrationStats.id
    });
    dismissHandler();
  }, [navigateTo, migrationStats.id, dismissHandler]);
  const url = (0, _react.useMemo)(() => getAppUrl(navParams), [getAppUrl, navParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.dashboardsService.polling.successText",
    defaultMessage: "Migration \"{name}\" has finished. Results have been added to the translated dashboards page.",
    values: {
      name: migrationStats.name
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClick,
    href: url,
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.securitySolution.siemMigrations.dashboardsService.polling.successLinkText', {
    defaultMessage: 'Go to translated dashboards'
  }))));
};