"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMissingLookupsListStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _components = require("../../../../../../../common/components");
var _use_upsert_resources = require("../../../../../../service/hooks/use_upsert_resources");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/data_input_flyout/steps/lookups/sub_steps/missing_lookups_list/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useMissingLookupsListStep = ({
  status,
  migrationStats,
  missingLookups,
  uploadedLookups,
  addUploadedLookups,
  onCopied
}) => {
  const {
    upsertResources,
    isLoading,
    error
  } = (0, _use_upsert_resources.useUpsertResources)(addUploadedLookups);
  const omitLookup = (0, _react.useCallback)(lookupName => {
    // Saving the lookup with an empty content to omit it.
    // The translation will ignore this lookup and will not cause partial translations.
    upsertResources(migrationStats.id, [{
      type: 'lookup',
      name: lookupName,
      content: ''
    }]);
  }, [upsertResources, migrationStats]);
  const listStepStatus = (0, _react.useMemo)(() => {
    if (isLoading) {
      return 'loading';
    }
    if (error) {
      return 'danger';
    }
    return status;
  }, [isLoading, error, status]);
  return {
    title: i18n.LOOKUPS_DATA_INPUT_COPY_TITLE,
    status: listStepStatus,
    children: /*#__PURE__*/_react.default.createElement(_components.MissingLookupsList, {
      onCopied: onCopied,
      missingLookups: missingLookups,
      uploadedLookups: uploadedLookups,
      omitLookup: omitLookup,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    })
  };
};
exports.useMissingLookupsListStep = useMissingLookupsListStep;