"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TranslatedRuleQuery = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _validation_warning_codes = require("../../../../../../../detection_engine/rule_creation/constants/validation_warning_codes");
var _use_form_with_warnings = require("../../../../../../../common/hooks/use_form_with_warnings");
var _schema = require("../schema");
var _header = require("./header");
var _query_editor = require("./query_editor");
var _query_viewer = require("./query_viewer");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rule_details_flyout/tabs/translation/query_details/translated_rule_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const transformQueryLanguage = language => {
  switch (language) {
    case 'eql':
      return 'EQL';
    case 'esql':
      return 'ES|QL';
    case 'kuery':
      return 'KQL';
    case 'lucene':
      return 'Lucene';
  }
};
const TranslatedRuleQuery = exports.TranslatedRuleQuery = /*#__PURE__*/_react.default.memo(({
  migrationRule,
  matchedPrebuiltRule,
  onTranslationUpdate
}) => {
  var _migrationRule$elasti;
  const isInstalled = !!((_migrationRule$elasti = migrationRule.elastic_rule) !== null && _migrationRule$elasti !== void 0 && _migrationRule$elasti.id);
  const canEdit = !matchedPrebuiltRule && !isInstalled;
  const translatedData = (0, _react.useMemo)(() => {
    var _migrationRule$elasti2, _migrationRule$elasti3, _migrationRule$elasti4, _migrationRule$elasti5, _migrationRule$elasti6, _migrationRule$elasti7;
    let ruleName = (_migrationRule$elasti2 = (_migrationRule$elasti3 = migrationRule.elastic_rule) === null || _migrationRule$elasti3 === void 0 ? void 0 : _migrationRule$elasti3.title) !== null && _migrationRule$elasti2 !== void 0 ? _migrationRule$elasti2 : '';
    let title = i18n.CUSTOM_TRANSLATION_TITLE;
    let titleTooltip = i18n.TRANSLATION_QUERY_TOOLTIP;
    let query = (_migrationRule$elasti4 = (_migrationRule$elasti5 = migrationRule.elastic_rule) === null || _migrationRule$elasti5 === void 0 ? void 0 : _migrationRule$elasti5.query) !== null && _migrationRule$elasti4 !== void 0 ? _migrationRule$elasti4 : '';
    let language = (_migrationRule$elasti6 = (_migrationRule$elasti7 = migrationRule.elastic_rule) === null || _migrationRule$elasti7 === void 0 ? void 0 : _migrationRule$elasti7.query_language) !== null && _migrationRule$elasti6 !== void 0 ? _migrationRule$elasti6 : '';
    let queryPlaceholder = i18n.TRANSLATION_QUERY_PLACEHOLDER;
    if (matchedPrebuiltRule) {
      ruleName = matchedPrebuiltRule.name;
      if (matchedPrebuiltRule.type === 'machine_learning') {
        title = i18n.MACHINE_LEARNING_RULE_TITLE;
        titleTooltip = i18n.MACHINE_LEARNING_RULE_TOOLTIP;
        queryPlaceholder = i18n.MACHINE_LEARNING_RULE_QUERY_PLACEHOLDER;
      } else {
        var _matchedPrebuiltRule$;
        title = i18n.PREBUILT_RULE_TITLE(transformQueryLanguage(matchedPrebuiltRule.language));
        query = (_matchedPrebuiltRule$ = matchedPrebuiltRule.query) !== null && _matchedPrebuiltRule$ !== void 0 ? _matchedPrebuiltRule$ : '';
        language = matchedPrebuiltRule.language;
      }
    }
    return {
      ruleName,
      title,
      titleTooltip,
      query,
      language,
      queryPlaceholder
    };
  }, [matchedPrebuiltRule, migrationRule.elastic_rule]);
  const formDefaultValue = (0, _react.useMemo)(() => {
    return {
      ruleName: translatedData.ruleName,
      queryBar: {
        query: {
          query: translatedData.query,
          language: 'esql'
        }
      }
    };
  }, [translatedData.query, translatedData.ruleName]);
  const {
    form
  } = (0, _use_form_with_warnings.useFormWithWarnings)({
    defaultValue: formDefaultValue,
    options: {
      stripEmptyFields: false,
      warningValidationCodes: _validation_warning_codes.VALIDATION_WARNING_CODES
    },
    schema: _schema.schema
  });
  const [isEditing, setIsEditing] = (0, _react.useState)(false);
  const onCancel = (0, _react.useCallback)(() => setIsEditing(false), []);
  const onEdit = (0, _react.useCallback)(() => {
    form.reset({
      defaultValue: formDefaultValue
    });
    setIsEditing(true);
  }, [form, formDefaultValue]);
  const onSave = (0, _react.useCallback)(async (newRuleName, newQuery) => {
    await (onTranslationUpdate === null || onTranslationUpdate === void 0 ? void 0 : onTranslationUpdate(newRuleName, newQuery));
    setIsEditing(false);
  }, [onTranslationUpdate]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.QueryHeader, {
    title: translatedData.title,
    tooltip: translatedData.titleTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }), isEditing ? /*#__PURE__*/_react.default.createElement(_query_editor.QueryEditor, {
    ruleName: translatedData.ruleName,
    query: translatedData.query,
    onSave: onSave,
    onCancel: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_query_viewer.QueryViewer, {
    ruleName: translatedData.ruleName,
    language: translatedData.language,
    query: translatedData.query,
    queryPlaceholder: translatedData.queryPlaceholder,
    onEdit: canEdit ? onEdit : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }));
});
TranslatedRuleQuery.displayName = 'TranslatedRuleQuery';