"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTooltipContent = exports.getPatternListWithoutSignals = exports.getDataViewSelectOptions = exports.StyledFormRow = exports.StyledButtonEmpty = exports.StyledBadge = exports.ResetButton = exports.PopoverContent = exports.FormRow = exports.Blockquote = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FormRow = exports.FormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  display: ${({
  $expandAdvancedOptions
}) => $expandAdvancedOptions ? 'flex' : 'none'};
  max-width: none;
`;
const StyledFormRow = exports.StyledFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  max-width: none;
`;
const StyledButtonEmpty = exports.StyledButtonEmpty = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  &:enabled:focus,
  &:focus {
    background-color: transparent;
  }
`;
const ResetButton = exports.ResetButton = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  width: fit-content;

  &:enabled:focus,
  &:focus {
    background-color: transparent;
  }
`;
const PopoverContent = exports.PopoverContent = _styledComponents.default.div`
  width: 600px;
`;
const StyledBadge = exports.StyledBadge = /*#__PURE__*/(0, _react.memo)(({
  color,
  children,
  'data-test-subj': dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    "data-test-subj": dataTestSubj,
    css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};

          &,
          .euiBadge__text {
            cursor: pointer;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, children);
});
StyledBadge.displayName = 'StyledBadge';
const Blockquote = exports.Blockquote = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
        display: block;
        border-color: ${euiTheme.colors.darkShade};
        border-left: ${euiTheme.border.thick};
        margin: ${euiTheme.size.s} 0 ${euiTheme.size.s} ${euiTheme.size.s};
        padding: ${euiTheme.size.s};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, children);
});
Blockquote.displayName = 'Blockquote';
const getDataViewSelectOptions = ({
  dataViewId,
  defaultDataViewId,
  isModified,
  isOnlyDetectionAlerts,
  kibanaDataViews
}) => isOnlyDetectionAlerts ? [{
  inputDisplay: /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "security-alerts-option-super",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }), " ", i18n.SIEM_SECURITY_DATA_VIEW_LABEL, /*#__PURE__*/_react.default.createElement(StyledBadge, {
    "data-test-subj": "security-alerts-option-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  }, i18n.ALERTS_BADGE_TITLE)),
  value: defaultDataViewId
}] : kibanaDataViews.map(({
  title,
  id
}) => ({
  inputDisplay: id === defaultDataViewId ? /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "security-option-super",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoSecurity",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }), " ", i18n.SECURITY_DEFAULT_DATA_VIEW_LABEL, isModified && id === dataViewId && /*#__PURE__*/_react.default.createElement(StyledBadge, {
    "data-test-subj": "security-modified-option-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 17
    }
  }, i18n.MODIFIED_BADGE_TITLE)) : /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "dataView-option-super",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoKibana",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }), " ", title, isModified && id === dataViewId && /*#__PURE__*/_react.default.createElement(StyledBadge, {
    "data-test-subj": "security-modified-option-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 17
    }
  }, i18n.MODIFIED_BADGE_TITLE)),
  value: id
}));
exports.getDataViewSelectOptions = getDataViewSelectOptions;
const getTooltipContent = ({
  isOnlyDetectionAlerts,
  isPopoverOpen,
  selectedPatterns,
  signalIndexName
}) => {
  if (isPopoverOpen || isOnlyDetectionAlerts && !signalIndexName) {
    return null;
  }
  return (isOnlyDetectionAlerts ? [signalIndexName] : selectedPatterns).join(', ');
};
exports.getTooltipContent = getTooltipContent;
const getPatternListWithoutSignals = (patternList, signalIndexName) => patternList.filter(p => p !== signalIndexName);
exports.getPatternListWithoutSignals = getPatternListWithoutSignals;