"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsFlyoutOverview = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_flyout_context = require("../../hooks/use_flyout_context");
var _common = require("../../../../constants/common");
var _indicator = require("../../../../../../common/threat_intelligence/types/indicator");
var _unwrap_value = require("../../utils/unwrap_value");
var _empty_prompt = require("./empty_prompt");
var _block = require("./block");
var _highlighted_values_table = require("./highlighted_values_table");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/flyout/overview_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const highLevelFields = [_indicator.RawIndicatorFieldId.Feed, _indicator.RawIndicatorFieldId.Type, _indicator.RawIndicatorFieldId.MarkingTLP, _indicator.RawIndicatorFieldId.Confidence];
const IndicatorsFlyoutOverview = ({
  indicator,
  onViewAllFieldsInTable
}) => {
  const {
    indicatorName
  } = (0, _use_flyout_context.useIndicatorsFlyoutContext)();
  const indicatorType = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Type);
  const highLevelBlocks = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, highLevelFields.map(field => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_block.IndicatorBlock, {
    indicator: indicator,
    field: field,
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_HIGH_LEVEL_BLOCKS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  })))), [indicator]);
  const indicatorDescription = (0, _react.useMemo)(() => {
    const unwrappedDescription = (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Description);
    return unwrappedDescription ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 35
      }
    }, unwrappedDescription) : null;
  }, [indicator]);
  const title = indicatorName != null ? indicatorName : (0, _unwrap_value.unwrapValue)(indicator, _indicator.RawIndicatorFieldId.Name) || _common.EMPTY_VALUE;
  if (!indicatorType) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.IndicatorEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, title)), indicatorDescription, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }), highLevelBlocks, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyoutOverviewTable.highlightedFields",
    defaultMessage: "Highlighted fields",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onViewAllFieldsInTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.threatIntelligence.indicator.flyoutOverviewTable.viewAllFieldsInTable",
    defaultMessage: "View all fields in table",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_highlighted_values_table.HighlightedValuesTable, {
    indicator: indicator,
    "data-test-subj": _test_ids.INDICATORS_FLYOUT_OVERVIEW_TABLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }));
};
exports.IndicatorsFlyoutOverview = IndicatorsFlyoutOverview;