"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterInContextMenu = exports.FilterInCellAction = exports.FilterInButtonIcon = exports.FilterInButtonEmpty = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_filter_in_out = require("../hooks/use_filter_in_out");
var _filter = require("../utils/filter");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/query_bar/components/filter_in.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ICON_TYPE = 'plusInCircle';
/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component renders an {@link EuiButtonIcon}.
 *
 * @returns filter in button icon
 */
const FilterInButtonIcon = ({
  data,
  field,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterIn
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.FILTER_FOR_TITLE,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.FILTER_FOR_TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    size: "xs",
    color: "primary",
    onClick: filterFn,
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component renders an {@link EuiButtonEmpty}.
 *
 * @returns filter in button empty
 */
exports.FilterInButtonIcon = FilterInButtonIcon;
const FilterInButtonEmpty = ({
  data,
  field,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterIn
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.FILTER_FOR_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.FILTER_FOR_TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    color: "primary",
    onClick: filterFn,
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, _translations.FILTER_FOR_TITLE));
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component is to be used in an EuiContextMenu.
 *
 * @returns filter in {@link EuiContextMenuItem} for a context menu
 */
exports.FilterInButtonEmpty = FilterInButtonEmpty;
const FilterInContextMenu = ({
  data,
  field,
  'data-test-subj': dataTestSub,
  onAnnounce
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterIn
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "filterIn",
    icon: "plusInCircle",
    size: "s",
    onClick: () => {
      filterFn();
      onAnnounce((0, _translations.FILTER_IN_ANNOUNCEMENT)(field, typeof data === 'string' ? data : ''));
    },
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, _translations.FILTER_FOR_TITLE);
};

/**
 * Retrieves the indicator's field and value, then creates a new {@link Filter} and adds it to the {@link FilterManager}.
 *
 * This component is to be used in an EuiDataGrid.
 *
 * @returns filter in button for data grid
 */
exports.FilterInContextMenu = FilterInContextMenu;
const FilterInCellAction = ({
  data,
  field,
  Component,
  'data-test-subj': dataTestSub
}) => {
  const {
    filterFn
  } = (0, _use_filter_in_out.useFilterInOut)({
    indicator: data,
    field,
    filterType: _filter.FilterIn
  });
  if (!filterFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.FILTER_FOR_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Component, {
    "aria-label": _translations.FILTER_FOR_TITLE,
    iconType: ICON_TYPE,
    onClick: filterFn,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, _translations.FILTER_FOR_TITLE)));
};
exports.FilterInCellAction = FilterInCellAction;