"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimelineButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _open_timeline_modal = require("../../open_timeline/open_timeline_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/modal/actions/open_timeline_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const actionTimelineToHide = ['createFrom'];

/**
 * Renders a button that opens the `OpenTimelineModal` to allow users to select a saved timeline to open
 */
const OpenTimelineButton = exports.OpenTimelineButton = /*#__PURE__*/_react.default.memo(() => {
  const [showTimelineModal, setShowTimelineModal] = (0, _react.useState)(false);
  const toggleTimelineModal = (0, _react.useCallback)(() => setShowTimelineModal(prev => !prev), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "timeline-modal-open-timeline-button",
    onClick: toggleTimelineModal,
    "aria-label": i18n.OPEN_TIMELINE_BTN_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, i18n.OPEN_TIMELINE_BTN), showTimelineModal ? /*#__PURE__*/_react.default.createElement(_open_timeline_modal.OpenTimelineModal, {
    onClose: toggleTimelineModal,
    hideActions: actionTimelineToHide,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }) : null);
});
OpenTimelineButton.displayName = 'OpenTimelineButton';