"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProcess = exports.USER_NAME_FIELD_NAME = exports.PROCESS_NAME_FIELD_NAME = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../common/components/draggables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/netflow/netflow_columns/user_process.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PROCESS_NAME_FIELD_NAME = exports.PROCESS_NAME_FIELD_NAME = 'process.name';
const USER_NAME_FIELD_NAME = exports.USER_NAME_FIELD_NAME = 'user.name';

/**
 * Renders a column of draggable badges containing:
 * - `user.name`
 * - `process.name`
 */
const UserProcess = exports.UserProcess = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  processName,
  userName,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  "data-test-subj": "user-process",
  direction: "column",
  justifyContent: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 3
  }
}, userName != null ? (0, _fp.uniq)(userName).map(user => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: user,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  "data-test-subj": "user-name",
  eventId: eventId,
  field: USER_NAME_FIELD_NAME,
  value: user,
  iconType: "user",
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 13
  }
}))) : null, processName != null ? (0, _fp.uniq)(processName).map(process => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: process,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: eventId,
  field: PROCESS_NAME_FIELD_NAME,
  value: process,
  iconType: "console",
  isAggregatable: true,
  fieldType: "keyword",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 13
  }
}))) : null));
UserProcess.displayName = 'UserProcess';