"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderThreatMatchRows = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _constants = require("../../../../../../../common/constants");
var _event_id = require("../../../../../../common/components/event_details/event_id");
var _row_renderer = require("../row_renderer");
var _threat_match_row = require("./threat_match_row");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/cti/threat_match_rows.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SpacedContainer = _styledComponents.default.div`
  margin: ${({
  theme
}) => theme.eui.euiSizeS} 0;
`;
const renderThreatMatchRows = ({
  data,
  scopeId
}) => {
  return /*#__PURE__*/_react.default.createElement(ThreatMatchRowWrapper, {
    data: data,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 10
    }
  });
};
exports.renderThreatMatchRows = renderThreatMatchRows;
const MAX_INDICATOR_VISIBLE = 2;
const ThreatMatchRowWrapper = ({
  data,
  scopeId
}) => {
  const indicators = (0, _lodash.get)(data, _constants.ENRICHMENT_DESTINATION_PATH);
  const eventId = (0, _lodash.get)(data, _event_id.ID_FIELD_NAME);
  const getThreatMatchRows = (0, _react.useCallback)((mode = 'max') => {
    const allIndicators = mode === 'max' ? indicators.slice(0, MAX_INDICATOR_VISIBLE) : indicators;
    return /*#__PURE__*/_react.default.createElement(_row_renderer.RowRendererContainer, {
      "data-test-subj": "threat-match-row-renderer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(SpacedContainer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }, allIndicators.map((indicator, index) => {
      const contextId = `threat-match-row-${scopeId}-${eventId}-${index}`;
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: contextId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_threat_match_row.ThreatMatchRow, {
        scopeId: scopeId,
        contextId: contextId,
        data: indicator,
        eventId: eventId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 19
        }
      }), index < indicators.length - 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 53
        }
      }));
    })));
  }, [indicators, eventId, scopeId]);
  const renderModalChildren = (0, _react.useCallback)(() => getThreatMatchRows('all'), [getThreatMatchRows]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, getThreatMatchRows()), indicators.length > MAX_INDICATOR_VISIBLE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ThreatMatchRowModal, {
    title: (0, _translations.SHOW_ALL_INDICATOR_MATCHES)(indicators.length),
    renderChildren: renderModalChildren,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  })));
};
const ThreatMatchRowModal = ({
  title,
  renderChildren
}) => {
  const [isModalVisible, setShowModal] = (0, _react.useState)(false);
  const closeModal = () => setShowModal(false);
  const showModal = () => setShowModal(true);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  let modal;
  if (isModalVisible) {
    modal = /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: closeModal,
      "aria-labelledby": modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      "data-test-subj": "threat-match-row-modal",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }, _translations.ALL_INDICATOR_MATCHES_MODAL_HEADER)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }, renderChildren()), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: closeModal,
      fill: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }, _translations.ALL_INDICATOR_MATCHES_MODAL_CLOSE)));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "threat-match-row-show-all",
    iconType: "popout",
    color: "primary",
    onClick: showModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, title), modal);
};