"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tokens = exports.SuricataSignature = exports.SURICATA_SIGNATURE_ID_FIELD_NAME = exports.SURICATA_SIGNATURE_FIELD_NAME = exports.DraggableSignatureId = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggable_wrapper = require("../../../../../../common/components/drag_and_drop/draggable_wrapper");
var _helpers = require("../../../../../../common/components/drag_and_drop/helpers");
var _links = require("../../../../../../common/components/links");
var _helpers2 = require("../helpers");
var _suricata_links = require("./suricata_links");
var _draggables = require("../../../../../../common/components/draggables");
var _data_provider = require("../../../data_providers/data_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/suricata/suricata_signature.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SURICATA_SIGNATURE_FIELD_NAME = exports.SURICATA_SIGNATURE_FIELD_NAME = 'suricata.eve.alert.signature';
const SURICATA_SIGNATURE_ID_FIELD_NAME = exports.SURICATA_SIGNATURE_ID_FIELD_NAME = 'suricata.eve.alert.signature_id';
const SignatureFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 77px;
`;
SignatureFlexItem.displayName = 'SignatureFlexItem';
const Badge = (0, _styledComponents.default)(_eui.EuiBadge)`
  vertical-align: top;
`;
Badge.displayName = 'Badge';
const LinkFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: 6px;
`;
LinkFlexItem.displayName = 'LinkFlexItem';
const Tokens = exports.Tokens = /*#__PURE__*/_react.default.memo(({
  tokens
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tokens.map(token => /*#__PURE__*/_react.default.createElement(_helpers2.TokensFlexItem, {
  key: token,
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "tag",
  color: "hollow",
  title: "",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 9
  }
}, token)))));
Tokens.displayName = 'Tokens';
const DraggableSignatureId = exports.DraggableSignatureId = /*#__PURE__*/_react.default.memo(({
  id,
  signatureId
}) => {
  const dataProviderProp = (0, _react.useMemo)(() => ({
    and: [],
    enabled: true,
    id: (0, _helpers.escapeDataProviderId)(`suricata-draggable-signature-id-${id}-sig-${signatureId}`),
    name: String(signatureId),
    excluded: false,
    kqlQuery: '',
    queryMatch: {
      field: SURICATA_SIGNATURE_ID_FIELD_NAME,
      value: signatureId,
      operator: _data_provider.IS_OPERATOR
    }
  }), [id, signatureId]);
  const render = (0, _react.useCallback)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "signature-id-tooltip",
    content: SURICATA_SIGNATURE_ID_FIELD_NAME,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Badge, {
    iconType: "number",
    color: "hollow",
    title: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, signatureId)), [signatureId]);
  return /*#__PURE__*/_react.default.createElement(SignatureFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DraggableWrapper, {
    dataProvider: dataProviderProp,
    render: render,
    isAggregatable: true,
    fieldType: 'keyword',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }));
});
DraggableSignatureId.displayName = 'DraggableSignatureId';
const SuricataSignature = exports.SuricataSignature = /*#__PURE__*/_react.default.memo(({
  contextId,
  id,
  signature,
  signatureId
}) => {
  const tokens = (0, _suricata_links.getBeginningTokens)(signature);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DraggableSignatureId, {
    id: `draggable-signature-id-${contextId}-${id}`,
    signatureId: signatureId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(Tokens, {
    tokens: tokens,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(LinkFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    "data-test-subj": "draggable-signature-link",
    field: SURICATA_SIGNATURE_FIELD_NAME,
    id: `suricata-signature-default-draggable-${contextId}-${id}-${SURICATA_SIGNATURE_FIELD_NAME}`,
    value: signature,
    tooltipPosition: "bottom",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_links.GoogleLink, {
    link: signature,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, signature.split(' ').splice(tokens.length).join(' '))))));
});
SuricataSignature.displayName = 'SuricataSignature';