"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _note_cards = require("../../notes/note_cards");
var i18n = _interopRequireWildcard(require("./translations"));
var _user_privileges = require("../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/properties/notes_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * z-index override is needed because otherwise NotesFlyout appears below
 * Timeline Modal as they both have same z-index of 1000
 */
const NotesFlyoutContainer = (0, _styledComponents.default)(_eui.EuiFlyoutResizable)`
  /*
  * We want the width of flyout to be less than 50% of screen because
  * otherwise it interferes with the delete notes modal
  * */
  width: 30%;
  z-index: ${props => {
  var _eui$euiZFlyout$toFix;
  return ((_eui$euiZFlyout$toFix = props.theme.eui.euiZFlyout.toFixed()) !== null && _eui$euiZFlyout$toFix !== void 0 ? _eui$euiZFlyout$toFix : 1000) + 2;
}} !important;
`;
const NotesFlyout = exports.NotesFlyout = /*#__PURE__*/_react.default.memo(function NotesFlyout(props) {
  const {
    eventId,
    toggleShowAddNote,
    show,
    onClose,
    associateNote,
    notes,
    timelineId,
    onCancel
  } = props;
  const {
    notesPrivileges: {
      crud: showAddNote
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const notesFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'notesFlyoutTitle'
  });
  if (!show || !eventId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(NotesFlyoutContainer, {
    ownFocus: false,
    className: "timeline-notes-flyout",
    "data-test-subj": "timeline-notes-flyout",
    onClose: onClose,
    "aria-labelledby": notesFlyoutTitleId,
    minWidth: 500,
    maxWidth: 1400,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, i18n.NOTES))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_note_cards.NoteCards, {
    ariaRowindex: 0,
    associateNote: associateNote,
    className: "notes-in-flyout",
    "data-test-subj": "note-cards",
    notes: notes,
    showAddNote: showAddNote,
    toggleShowAddNote: toggleShowAddNote,
    eventId: eventId,
    timelineId: timelineId,
    onCancel: onCancel,
    showToggleEventDetailsAction: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }))));
});