"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.NO_NOTES = exports.FETCH_NOTES_ERROR = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _save_timeline = require("../../../notes/save_timeline");
var _add_note = require("../../../../../notes/components/add_note");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _test_ids = require("../../../../../notes/components/test_ids");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _translations = require("../../../open_timeline/note_previews/translations");
var _empty_value = require("../../../../../common/components/empty_value");
var _selectors = require("../../../../store/selectors");
var _notes = require("../../../../../notes");
var _timeline = require("../../../../../../common/api/timeline");
var _notes_list = require("../../../../../notes/components/notes_list");
var _old_notes = require("../../../notes/old_notes");
var _participants = require("../../../notes/participants");
var _translations2 = require("../../../notes/translations");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _selectors2 = require("../selectors");
var _scroll_to_top = require("../../../../../common/components/scroll_to_top");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/notes/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FETCH_NOTES_ERROR = exports.FETCH_NOTES_ERROR = _i18n.i18n.translate('xpack.securitySolution.notes.fetchNotesErrorLabel', {
  defaultMessage: 'Error fetching notes'
});
const NO_NOTES = exports.NO_NOTES = _i18n.i18n.translate('xpack.securitySolution.notes.noNotesLabel', {
  defaultMessage: 'No notes have been created for this Timeline.'
});
/**
 * Renders the notes tab content.
 * At this time the component support the old notes system and the new notes system (via the securitySolutionNotesDisabled feature flag).
 * The old notes system is deprecated and will be removed in the future.
 * In both cases, the component fetches the notes for the timeline and renders:
 * - the timeline description
 * - the notes list
 * - the participants list
 * - the markdown to create a new note and the add note button
 */
const NotesTabContentComponent = exports.default = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const {
    addError: addErrorToast
  } = (0, _use_app_toasts.useAppToasts)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    notesPrivileges
  } = (0, _user_privileges.useUserPrivileges)();
  const canCreateNotes = notesPrivileges.crud;
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  const getScrollToTop = (0, _react.useMemo)(() => (0, _selectors2.getScrollToTopSelector)(), []);
  const scrollToTop = (0, _use_selector.useShallowEqualSelector)(state => getScrollToTop(state, timelineId));
  (0, _scroll_to_top.useScrollToTop)('#scrollableNotes', !!scrollToTop);
  const timeline = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const timelineSavedObjectId = (0, _react.useMemo)(() => {
    var _timeline$savedObject;
    return (_timeline$savedObject = timeline.savedObjectId) !== null && _timeline$savedObject !== void 0 ? _timeline$savedObject : '';
  }, [timeline.savedObjectId]);
  const isTimelineSaved = (0, _react.useMemo)(() => timeline.status === _timeline.TimelineStatusEnum.active, [timeline.status]);
  const fetchNotes = (0, _react.useCallback)(() => dispatch((0, _notes.fetchNotesBySavedObjectIds)({
    savedObjectIds: [timelineSavedObjectId]
  })), [dispatch, timelineSavedObjectId]);
  (0, _react.useEffect)(() => {
    if (isTimelineSaved) {
      fetchNotes();
    }
  }, [fetchNotes, isTimelineSaved]);
  const selectNotesBySavedObjectId = (0, _react.useMemo)(() => (0, _notes.makeSelectNotesBySavedObjectId)(), []);
  const notes = (0, _reactRedux.useSelector)(state => selectNotesBySavedObjectId(state, timelineSavedObjectId));
  const fetchStatus = (0, _reactRedux.useSelector)(state => (0, _notes.selectFetchNotesBySavedObjectIdsStatus)(state));
  const fetchError = (0, _reactRedux.useSelector)(state => (0, _notes.selectFetchNotesBySavedObjectIdsError)(state));

  // show a toast if the fetch notes call fails
  (0, _react.useEffect)(() => {
    if (fetchStatus === _notes.ReqStatus.Failed && fetchError) {
      addErrorToast(null, {
        title: FETCH_NOTES_ERROR
      });
    }
  }, [addErrorToast, fetchError, fetchStatus]);

  // if timeline was saved with a description, we show it at the very top of the notes tab
  const timelineDescription = (0, _react.useMemo)(() => {
    if (!(timeline !== null && timeline !== void 0 && timeline.description)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
      key: 'note-preview-description',
      username: (0, _empty_value.defaultToEmptyTag)(timeline.updatedBy),
      timestamp: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timeline.updated ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
        "data-test-subj": "updated",
        value: new Date(timeline.updated),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 17
        }
      }) : (0, _empty_value.getEmptyValue)()),
      event: _translations.ADDED_A_DESCRIPTION,
      timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
        size: "l",
        name: timeline.updatedBy || '?',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 27
        }
      }),
      "data-test-subj": _test_ids.TIMELINE_DESCRIPTION_COMMENT_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, timeline.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }));
  }, [timeline.description, timeline.updated, timeline.updatedBy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
        height: 100%;
        overflow: auto;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 13
    }
  }, _translations2.NOTES))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, securitySolutionNotesDisabled ? /*#__PURE__*/_react.default.createElement(_old_notes.OldNotes, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": 'new-notes-screen',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, timelineDescription, fetchStatus === _notes.ReqStatus.Loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
    "data-test-subj": _test_ids.NOTES_LOADING_TEST_ID,
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 19
    }
  }), isTimelineSaved && fetchStatus === _notes.ReqStatus.Succeeded && notes.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 23
    }
  }, NO_NOTES))) : /*#__PURE__*/_react.default.createElement(_notes_list.NotesList, {
    notes: notes,
    options: {
      hideTimelineIcon: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 19
    }
  }), canCreateNotes && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_add_note.AddNote, {
    timelineId: timeline.savedObjectId,
    disableButton: !isTimelineSaved,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 21
    }
  }, !isTimelineSaved && /*#__PURE__*/_react.default.createElement(_save_timeline.SaveTimelineCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 44
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                  max-width: 350px;
                `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_participants.Participants, {
    notes: notes,
    timelineCreatedBy: timeline.createdBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 17
    }
  }))))));
});
NotesTabContentComponent.displayName = 'NotesTabContentComponent';

// eslint-disable-next-line import/no-default-export