"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryTabHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _react2 = require("@emotion/react");
var _use_timeline_events_count = require("../../../../../../common/hooks/use_timeline_events_count");
var _timeline = require("../../../../../../../common/api/timeline");
var _store = require("../../../../../store");
var _use_selector = require("../../../../../../common/hooks/use_selector");
var _defaults = require("../../../../../store/defaults");
var i18n = _interopRequireWildcard(require("./translations"));
var _search_or_filter = require("../../../search_or_filter");
var _data_providers = require("../../../data_providers");
var _layout = require("../../shared/layout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/tabs/query/header/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useStyles = shouldShowQueryBuilder => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react2.css)`
    position: relative;
    width: 100%;
    transition: 0.5s ease-in-out;
    overflow: hidden;
    display: block;
    max-height: ${shouldShowQueryBuilder ? '300px' : '0'};
    visibility: ${shouldShowQueryBuilder ? 'visible' : 'hidden'};
    margin-block-start: ${shouldShowQueryBuilder ? '0' : `calc(-1 * ${euiTheme.size.s})`};

    . ${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} & {
      display: block;
      max-height: 300px;
      visibility: visible;
      margin-block-start: 0;
    }
  `;
};
const QueryTabHeaderComponent = ({
  activeTab,
  filterManager,
  show,
  showCallOutUnauthorizedMsg,
  status,
  timelineId,
  showEventsCountBadge,
  totalCount
}) => {
  const {
    portalNode: timelineEventsCountPortalNode
  } = (0, _use_timeline_events_count.useTimelineEventsCountPortal)();
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const getIsDataProviderVisible = (0, _react.useMemo)(() => _store.timelineSelectors.dataProviderVisibilitySelector(), []);
  const timelineType = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).timelineType;
  });
  const isDataProviderVisible = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getIsDataProviderVis;
    return (_getIsDataProviderVis = getIsDataProviderVisible(state, timelineId)) !== null && _getIsDataProviderVis !== void 0 ? _getIsDataProviderVis : _defaults.timelineDefaults.isDataProviderVisible;
  });
  const shouldShowQueryBuilder = (0, _react.useMemo)(() => isDataProviderVisible || timelineType === _timeline.TimelineTypeEnum.template, [isDataProviderVisible, timelineType]);
  const dataProviderStyles = useStyles(shouldShowQueryBuilder);
  return /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutHeader, {
    "data-test-subj": `${activeTab}-tab-flyout-header`,
    hasBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: timelineEventsCountPortalNode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, showEventsCountBadge ? /*#__PURE__*/_react.default.createElement(_layout.EventsCountBadge, {
    "data-test-subj": "query-events-count",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, totalCount) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "timeline-date-picker-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_layout.TabHeaderContainer, {
    "data-test-subj": "timelineHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_search_or_filter.StatefulSearchOrFilter, {
    filterManager: filterManager,
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  })), showCallOutUnauthorizedMsg && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "timelineCallOutUnauthorized",
    title: i18n.CALL_OUT_UNAUTHORIZED_MSG,
    color: "warning",
    iconType: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  })), status === _timeline.TimelineStatusEnum.immutable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "timelineImmutableCallOut",
    title: i18n.CALL_OUT_IMMUTABLE,
    color: "primary",
    iconType: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  })), show ? /*#__PURE__*/_react.default.createElement("div", {
    css: dataProviderStyles,
    className: "data-providers-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_data_providers.DataProviders, {
    timelineId: timelineId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 19
    }
  })) : null)))));
};
const QueryTabHeader = exports.QueryTabHeader = /*#__PURE__*/_react.default.memo(QueryTabHeaderComponent);