"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reviewRuleUpgradeRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
var _route_limited_concurrency_tag = require("../../../../../utils/route_limited_concurrency_tag");
var _constants = require("../../constants");
var _review_rule_upgrade_handler = require("./review_rule_upgrade_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reviewRuleUpgradeRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _prebuilt_rules.REVIEW_RULE_UPGRADE_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    },
    options: {
      tags: [(0, _route_limited_concurrency_tag.routeLimitedConcurrencyTag)(_constants.PREBUILT_RULES_UPGRADE_REVIEW_CONCURRENCY)],
      timeout: {
        idleSocket: _constants.PREBUILT_RULES_OPERATION_SOCKET_TIMEOUT_MS
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_prebuilt_rules.ReviewRuleUpgradeRequestBody)
      }
    }
  }, _review_rule_upgrade_handler.reviewRuleUpgradeHandler);
};
exports.reviewRuleUpgradeRoute = reviewRuleUpgradeRoute;