"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndicatorMatchAlertType = void 0;
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _coreApplicationCommon = require("@kbn/core-application-common");
var _constants = require("../../../../../common/constants");
var _rule_schema = require("../../rule_schema");
var _indicator_match = require("./indicator_match");
var _utils = require("../utils");
var _wrap_suppressed_alerts = require("../utils/wrap_suppressed_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createIndicatorMatchAlertType = () => {
  return {
    id: _securitysolutionRules.INDICATOR_RULE_TYPE_ID,
    name: 'Indicator Match Rule',
    ruleTaskTimeout: '1h',
    validate: {
      params: {
        validate: object => {
          return _rule_schema.ThreatRuleParams.parse(object);
        },
        /**
         * validate rule params when rule is bulk edited (update and created in future as well)
         * returned params can be modified (useful in case of version increment)
         * @param mutatedRuleParams
         * @returns mutatedRuleParams
         */
        validateMutatedParams: mutatedRuleParams => {
          (0, _utils.validateIndexPatterns)(mutatedRuleParams.index);
          return mutatedRuleParams;
        }
      }
    },
    schemas: {
      params: {
        type: 'zod',
        schema: _rule_schema.ThreatRuleParams
      }
    },
    actionGroups: [{
      id: 'default',
      name: 'Default'
    }],
    defaultActionGroupId: 'default',
    actionVariables: {
      context: [{
        name: 'server',
        description: 'the server'
      }]
    },
    minimumLicenseRequired: 'basic',
    isExportable: false,
    category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security.id,
    producer: _constants.SERVER_APP_ID,
    solution: 'security',
    async executor(execOptions) {
      const {
        sharedParams,
        services,
        state
      } = execOptions;
      const wrapSuppressedHits = (events, buildReasonMessage) => (0, _wrap_suppressed_alerts.wrapSuppressedAlerts)({
        events,
        buildReasonMessage,
        sharedParams
      });
      const result = await (0, _indicator_match.indicatorMatchExecutor)({
        sharedParams,
        services,
        eventsTelemetry: sharedParams.eventsTelemetry,
        wrapSuppressedHits,
        licensing: sharedParams.licensing,
        scheduleNotificationResponseActionsService: sharedParams.scheduleNotificationResponseActionsService
      });
      return {
        ...result,
        state
      };
    }
  };
};
exports.createIndicatorMatchAlertType = createIndicatorMatchAlertType;