"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSourcesSyncService = void 0;
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSourcesSyncService = dataClient => {
  const {
    deps
  } = dataClient;
  const syncBySourceType = async ({
    soClient,
    sourceType,
    process
  }) => {
    const monitoringIndexSourceClient = new _saved_objects.MonitoringEntitySourceDescriptorClient({
      soClient,
      namespace: deps.namespace
    });
    const sources = await monitoringIndexSourceClient.findSourcesByType(sourceType); // this will be index or integration
    if (sources.length === 0) {
      dataClient.log('debug', `No ${sourceType} monitoring sources found. Skipping sync.`);
      return;
    }
    const results = await Promise.allSettled(sources.map(s => process(s)));
    results.forEach(result => {
      if (result.status === 'rejected') {
        dataClient.log('warn', `Source processing failed: ${String(result.reason)}`);
      }
    });
  };
  return {
    syncBySourceType
  };
};
exports.createSourcesSyncService = createSourcesSyncService;