"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMarkdownPanel = void 0;
var _markdownViz = _interopRequireDefault(require("./markdown.viz.json"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Create markdown panel with a specific message
const createMarkdownPanel = (message, parsedPanel) => {
  var _panelJSON$embeddable, _panelJSON$embeddable2;
  const panelJSON = structuredClone(_markdownViz.default);
  // Set panel basic properties
  panelJSON.title = parsedPanel.title;

  // Set position from parsed_panel.position
  if (parsedPanel.position) {
    panelJSON.gridData = {
      x: parsedPanel.position.x,
      y: parsedPanel.position.y,
      w: parsedPanel.position.w,
      h: parsedPanel.position.h,
      i: parsedPanel.id
    };
    panelJSON.panelIndex = parsedPanel.id;
  }
  if ((_panelJSON$embeddable = panelJSON.embeddableConfig) !== null && _panelJSON$embeddable !== void 0 && (_panelJSON$embeddable2 = _panelJSON$embeddable.savedVis) !== null && _panelJSON$embeddable2 !== void 0 && _panelJSON$embeddable2.params) {
    panelJSON.embeddableConfig.savedVis.params.markdown = message;
  }
  return panelJSON;
};
exports.createMarkdownPanel = createMarkdownPanel;