"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleMigrationsDataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rule_migrations_data_integrations_client = require("./rule_migrations_data_integrations_client");
var _rule_migrations_data_prebuilt_rules_client = require("./rule_migrations_data_prebuilt_rules_client");
var _rule_migrations_data_rules_client = require("./rule_migrations_data_rules_client");
var _siem_migrations_data_lookups_client = require("../../common/data/siem_migrations_data_lookups_client");
var _rule_migrations_data_migration_client = require("./rule_migrations_data_migration_client");
var _siem_migrations_data_client = require("../../common/data/siem_migrations_data_client");
var _siem_migrations_data_resources_client = require("../../common/data/siem_migrations_data_resources_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RuleMigrationsDataClient extends _siem_migrations_data_client.SiemMigrationsDataClient {
  constructor(indexNameProviders, currentUser, esScopedClient, logger, spaceId, dependencies) {
    super(esScopedClient, logger);
    (0, _defineProperty2.default)(this, "migrations", void 0);
    (0, _defineProperty2.default)(this, "items", void 0);
    (0, _defineProperty2.default)(this, "resources", void 0);
    (0, _defineProperty2.default)(this, "integrations", void 0);
    (0, _defineProperty2.default)(this, "prebuiltRules", void 0);
    (0, _defineProperty2.default)(this, "lookups", void 0);
    this.migrations = new _rule_migrations_data_migration_client.RuleMigrationsDataMigrationClient(indexNameProviders.migrations, currentUser, esScopedClient, logger, dependencies);
    this.items = new _rule_migrations_data_rules_client.RuleMigrationsDataRulesClient(indexNameProviders.rules, currentUser, esScopedClient, logger, dependencies);
    this.resources = new _siem_migrations_data_resources_client.SiemMigrationsDataResourcesClient(indexNameProviders.resources, currentUser, esScopedClient, logger, dependencies);
    this.integrations = new _rule_migrations_data_integrations_client.RuleMigrationsDataIntegrationsClient(indexNameProviders.integrations, currentUser, esScopedClient, logger, dependencies);
    this.prebuiltRules = new _rule_migrations_data_prebuilt_rules_client.RuleMigrationsDataPrebuiltRulesClient(indexNameProviders.prebuiltrules, currentUser, esScopedClient, logger, dependencies);
    this.lookups = new _siem_migrations_data_lookups_client.SiemMigrationsDataLookupsClient(currentUser, esScopedClient, logger, spaceId);
  }
}
exports.RuleMigrationsDataClient = RuleMigrationsDataClient;