"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/alerting-plugin/server");
var _common = require("@kbn/alerting-plugin/common");
var _server3 = require("@kbn/rule-registry-plugin/server");
var _common2 = require("@kbn/fleet-plugin/common");
var _space_awareness_migration = require("./endpoint/migrations/space_awareness_migration");
var _saved_objects = require("./endpoint/services/saved_objects");
var _data_view_refresh_task = require("./lib/entity_analytics/entity_store/tasks/data_view_refresh/data_view_refresh_task");
var _ensure_indices_exists_for_policies = require("./endpoint/migrations/ensure_indices_exists_for_policies");
var _response_actions = require("./endpoint/lib/response_actions");
var _agent = require("./endpoint/routes/agent");
var _endpoint_package_policies_stats = require("./search_strategy/endpoint_package_policies_stats");
var _turn_off_policy_protections = require("./endpoint/migrations/turn_off_policy_protections");
var _endpoint = require("./search_strategy/endpoint");
var _schedule_notification_response_actions = require("./lib/detection_engine/rule_response_actions/schedule_notification_response_actions");
var _rule_types = require("./lib/detection_engine/rule_types");
var _routes = require("./routes");
var _limited_concurrency = require("./routes/limited_concurrency");
var _artifacts = require("./endpoint/lib/artifacts");
var _metadata = require("./endpoint/lib/metadata");
var _saved_objects2 = require("./saved_objects");
var _client = require("./client");
var _config = require("./config");
var _ui_settings = require("./ui_settings");
var _deprecations = require("./deprecations");
var _constants = require("../common/constants");
var _metadata2 = require("./endpoint/routes/metadata");
var _policy = require("./endpoint/routes/policy");
var _actions = require("./endpoint/routes/actions");
var _suggestions = require("./endpoint/routes/suggestions");
var _services = require("./endpoint/services");
var _endpoint_app_context_services = require("./endpoint/endpoint_app_context_services");
var _usage = require("./usage");
var _security_solution = require("./search_strategy/security_solution");
var _sender = require("./lib/telemetry/sender");
var _async_sender = require("./lib/telemetry/async_sender");
var _receiver = require("./lib/telemetry/receiver");
var _license = require("./lib/license");
var _license_watch = require("./endpoint/lib/policy/license_watch");
var _preview_policy = _interopRequireDefault(require("./lib/detection_engine/routes/index/preview_policy.json"));
var _rule_monitoring = require("./lib/detection_engine/rule_monitoring");
var _rule_actions_legacy = require("./lib/detection_engine/rule_actions_legacy");
var _create_security_rule_type_wrapper = require("./lib/detection_engine/rule_types/create_security_rule_type_wrapper");
var _request_context_factory = require("./request_context_factory");
var _feature_usage = require("./endpoint/services/feature_usage");
var _helpers = require("./lib/telemetry/helpers");
var _artifact = require("./lib/telemetry/artifact");
var _events = require("./lib/telemetry/event_based/events");
var _endpoint_fields = require("./search_strategy/endpoint_fields");
var _constants2 = require("../common/endpoint/constants");
var _privilege_monitoring_task = require("./lib/entity_analytics/privilege_monitoring/tasks/privilege_monitoring_task");
var _product_features_service = require("./lib/product_features_service/product_features_service");
var _risk_scoring_task = require("./lib/entity_analytics/risk_score/tasks/risk_scoring_task");
var _tasks = require("./lib/entity_analytics/entity_store/tasks");
var _protection_updates_note = require("./endpoint/routes/protection_updates_note");
var _risk_engine = require("../common/entity_analytics/risk_engine");
var _package_v = require("../common/endpoint/utils/package_v2");
var _tools = require("./assistant/tools");
var _turn_off_agent_policy_features = require("./endpoint/migrations/turn_off_agent_policy_features");
var _security_integrations = require("./security_integrations");
var _migrations = require("./lib/entity_analytics/migrations");
var _siem_migrations_service = require("./lib/siem_migrations/siem_migrations_service");
var _telemetry_config_provider = require("../common/telemetry_config/telemetry_config_provider");
var _telemetry_watch = require("./endpoint/lib/policy/telemetry_watch");
var _search_strategy = require("./threat_intelligence/search_strategy");
var _constants3 = require("../common/threat_intelligence/constants");
var _health_diagnostic_service = require("./lib/telemetry/diagnostic/health_diagnostic_service");
var _entity_risk_score = require("./assistant/tools/entity_risk_score/entity_risk_score");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "pluginContext", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "appClientFactory", void 0);
    (0, _defineProperty2.default)(this, "productFeaturesService", void 0);
    (0, _defineProperty2.default)(this, "ruleMonitoringService", void 0);
    (0, _defineProperty2.default)(this, "endpointAppContextService", new _endpoint_app_context_services.EndpointAppContextService());
    (0, _defineProperty2.default)(this, "siemMigrationsService", void 0);
    (0, _defineProperty2.default)(this, "telemetryReceiver", void 0);
    (0, _defineProperty2.default)(this, "telemetryEventsSender", void 0);
    (0, _defineProperty2.default)(this, "asyncTelemetryEventsSender", void 0);
    (0, _defineProperty2.default)(this, "healthDiagnosticService", void 0);
    (0, _defineProperty2.default)(this, "lists", void 0);
    // TODO: can we create ListPluginStart?
    (0, _defineProperty2.default)(this, "licensing$", void 0);
    (0, _defineProperty2.default)(this, "policyWatcher", void 0);
    (0, _defineProperty2.default)(this, "telemetryConfigProvider", void 0);
    (0, _defineProperty2.default)(this, "telemetryWatcher", void 0);
    (0, _defineProperty2.default)(this, "manifestTask", void 0);
    (0, _defineProperty2.default)(this, "completeExternalResponseActionsTask", void 0);
    (0, _defineProperty2.default)(this, "checkMetadataTransformsTask", void 0);
    (0, _defineProperty2.default)(this, "telemetryUsageCounter", void 0);
    (0, _defineProperty2.default)(this, "endpointContext", void 0);
    (0, _defineProperty2.default)(this, "isServerless", void 0);
    const serverConfig = (0, _config.createConfig)(context);
    this.pluginContext = context;
    this.config = serverConfig;
    this.logger = context.logger.get();
    this.appClientFactory = new _client.AppClientFactory();
    this.productFeaturesService = new _product_features_service.ProductFeaturesService(this.logger, this.config.experimentalFeatures);
    this.siemMigrationsService = new _siem_migrations_service.SiemMigrationsService(this.config, this.pluginContext.logger, this.pluginContext.env.packageInfo.version);
    this.ruleMonitoringService = (0, _rule_monitoring.createRuleMonitoringService)(this.config, this.logger);
    this.telemetryEventsSender = new _sender.TelemetryEventsSender(this.logger, this.config.experimentalFeatures);
    this.asyncTelemetryEventsSender = new _async_sender.AsyncTelemetryEventsSender(this.logger);
    this.telemetryReceiver = new _receiver.TelemetryReceiver(this.logger);
    this.telemetryConfigProvider = new _telemetry_config_provider.TelemetryConfigProvider();
    this.endpointContext = {
      logFactory: this.pluginContext.logger,
      service: this.endpointAppContextService,
      config: () => Promise.resolve(this.config),
      get serverConfig() {
        return serverConfig;
      },
      experimentalFeatures: this.config.experimentalFeatures
    };
    this.completeExternalResponseActionsTask = new _response_actions.CompleteExternalResponseActionsTask({
      endpointAppContext: this.endpointContext
    });
    this.isServerless = context.env.packageInfo.buildFlavor === 'serverless';
    this.logger.debug('plugin initialized');
    this.healthDiagnosticService = new _health_diagnostic_service.HealthDiagnosticServiceImpl(this.logger);
  }
  setup(core, plugins) {
    var _plugins$security2, _plugins$usageCollect, _plugins$osquery, _plugins$encryptedSav, _plugins$encryptedSav2, _plugins$cloud$isClou;
    this.logger.debug('plugin setup');
    const {
      appClientFactory,
      productFeaturesService,
      pluginContext,
      config,
      logger
    } = this;
    const experimentalFeatures = config.experimentalFeatures;
    (0, _saved_objects2.initSavedObjects)(core.savedObjects);
    (0, _saved_objects2.initEncryptedSavedObjects)({
      encryptedSavedObjects: plugins.encryptedSavedObjects,
      logger: this.logger
    });
    (0, _ui_settings.initUiSettings)(core.uiSettings, experimentalFeatures, config.enableUiSettingsValidations);
    productFeaturesService.setup(core, plugins);
    _events.events.forEach(eventConfig => {
      core.analytics.registerEventType(eventConfig);
    });
    this.ruleMonitoringService.setup(core, plugins);
    (0, _deprecations.registerDeprecations)({
      core,
      config: this.config,
      logger: this.logger
    });
    if (experimentalFeatures.riskScoringPersistence) {
      var _plugins$security;
      (0, _risk_scoring_task.registerRiskScoringTask)({
        getStartServices: core.getStartServices,
        kibanaVersion: pluginContext.env.packageInfo.version,
        logger: this.logger,
        auditLogger: (_plugins$security = plugins.security) === null || _plugins$security === void 0 ? void 0 : _plugins$security.audit.withoutRequest,
        taskManager: plugins.taskManager,
        telemetry: core.analytics,
        entityAnalyticsConfig: config.entityAnalytics,
        experimentalFeatures
      });
    }
    (0, _migrations.scheduleEntityAnalyticsMigration)({
      getStartServices: core.getStartServices,
      taskManager: plugins.taskManager,
      logger: this.logger,
      auditLogger: (_plugins$security2 = plugins.security) === null || _plugins$security2 === void 0 ? void 0 : _plugins$security2.audit.withoutRequest,
      kibanaVersion: pluginContext.env.packageInfo.version
    }).catch(err => {
      logger.error(`Error scheduling entity analytics migration: ${err}`);
    });
    if (!experimentalFeatures.entityStoreDisabled) {
      var _plugins$security3;
      (0, _tasks.registerEntityStoreFieldRetentionEnrichTask)({
        getStartServices: core.getStartServices,
        logger: this.logger,
        telemetry: core.analytics,
        taskManager: plugins.taskManager
      });
      (0, _data_view_refresh_task.registerEntityStoreDataViewRefreshTask)({
        getStartServices: core.getStartServices,
        appClientFactory,
        logger: this.logger,
        telemetry: core.analytics,
        taskManager: plugins.taskManager,
        auditLogger: (_plugins$security3 = plugins.security) === null || _plugins$security3 === void 0 ? void 0 : _plugins$security3.audit.withoutRequest,
        entityStoreConfig: config.entityAnalytics.entityStore,
        experimentalFeatures,
        kibanaVersion: pluginContext.env.packageInfo.version,
        isServerless: this.isServerless
      });
      (0, _tasks.registerEntityStoreSnapshotTask)({
        getStartServices: core.getStartServices,
        logger: this.logger,
        taskManager: plugins.taskManager
      });
    }
    (0, _privilege_monitoring_task.registerPrivilegeMonitoringTask)({
      getStartServices: core.getStartServices,
      taskManager: plugins.taskManager,
      logger: this.logger,
      telemetry: core.analytics,
      kibanaVersion: pluginContext.env.packageInfo.version,
      experimentalFeatures,
      config: this.config
    });
    const requestContextFactory = new _request_context_factory.RequestContextFactory({
      config,
      logger,
      core,
      plugins,
      endpointAppContextService: this.endpointAppContextService,
      ruleMonitoringService: this.ruleMonitoringService,
      siemMigrationsService: this.siemMigrationsService,
      kibanaVersion: pluginContext.env.packageInfo.version,
      kibanaBranch: pluginContext.env.packageInfo.branch,
      buildFlavor: pluginContext.env.packageInfo.buildFlavor,
      productFeaturesService
    });
    const router = core.http.createRouter();
    core.http.registerRouteHandlerContext(_constants.APP_ID, (context, request) => requestContextFactory.create(context, request));
    this.endpointAppContextService.setup({
      securitySolutionRequestContextFactory: requestContextFactory,
      cloud: plugins.cloud,
      loggerFactory: this.pluginContext.logger,
      telemetry: core.analytics,
      httpServiceSetup: core.http
    });
    (0, _usage.initUsageCollectors)({
      core,
      eventLogIndex: plugins.eventLog.getIndexPattern(),
      signalsIndex: _constants.DEFAULT_ALERTS_INDEX,
      ml: plugins.ml,
      usageCollection: plugins.usageCollection,
      logger,
      riskEngineIndexPatterns: {
        all: _risk_engine.allRiskScoreIndexPattern,
        latest: _risk_engine.latestRiskScoreIndexPattern
      },
      legacySignalsIndex: config.signalsIndex
    });
    this.telemetryUsageCounter = (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.createUsageCounter(_constants.APP_ID);
    plugins.cases.attachmentFramework.registerExternalReference({
      id: _constants.CASE_ATTACHMENT_ENDPOINT_TYPE_ID
    });
    const {
      ruleDataService
    } = plugins.ruleRegistry;
    let ruleDataClient = null;
    let previewRuleDataClient = null;
    const ruleDataServiceOptions = {
      feature: _constants.SERVER_APP_ID,
      registrationContext: 'security',
      dataset: _server3.Dataset.alerts,
      componentTemplateRefs: [_server2.ECS_COMPONENT_TEMPLATE_NAME],
      componentTemplates: [{
        name: 'mappings',
        mappings: (0, _common.mappingFromFieldMap)(_create_security_rule_type_wrapper.securityRuleTypeFieldMap, false)
      }],
      secondaryAlias: config.signalsIndex
    };
    ruleDataClient = ruleDataService.initializeIndex(ruleDataServiceOptions);
    const previewIlmPolicy = _preview_policy.default.policy;
    previewRuleDataClient = ruleDataService.initializeIndex({
      ...ruleDataServiceOptions,
      additionalPrefix: '.preview',
      ilmPolicy: previewIlmPolicy,
      secondaryAlias: undefined
    });
    const securityRuleTypeOptions = {
      lists: plugins.lists,
      docLinks: core.docLinks,
      actions: plugins.actions,
      logger: this.logger,
      config: this.config,
      publicBaseUrl: core.http.basePath.publicBaseUrl,
      ruleDataClient,
      ruleExecutionLoggerFactory: this.ruleMonitoringService.createRuleExecutionLogClientForExecutors,
      version: pluginContext.env.packageInfo.version,
      experimentalFeatures: config.experimentalFeatures,
      alerting: plugins.alerting,
      analytics: core.analytics,
      isServerless: this.isServerless,
      eventsTelemetry: this.telemetryEventsSender,
      licensing: plugins.licensing,
      scheduleNotificationResponseActionsService: (0, _schedule_notification_response_actions.getScheduleNotificationResponseActionsService)({
        endpointAppContextService: this.endpointAppContextService,
        osqueryCreateActionService: (_plugins$osquery = plugins.osquery) === null || _plugins$osquery === void 0 ? void 0 : _plugins$osquery.createActionService
      })
    };
    const securityRuleTypeWrapper = (0, _create_security_rule_type_wrapper.createSecurityRuleTypeWrapper)(securityRuleTypeOptions);
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createEqlAlertType)()));
    if (!experimentalFeatures.esqlRulesDisabled) {
      plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createEsqlAlertType)()));
    }
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createQueryAlertType)({
      id: _securitysolutionRules.SAVED_QUERY_RULE_TYPE_ID,
      name: 'Saved Query Rule'
    })));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createIndicatorMatchAlertType)()));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createMlAlertType)(plugins.ml)));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createQueryAlertType)({
      id: _securitysolutionRules.QUERY_RULE_TYPE_ID,
      name: 'Custom Query Rule'
    })));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createThresholdAlertType)()));
    plugins.alerting.registerType(securityRuleTypeWrapper((0, _rule_types.createNewTermsAlertType)()));

    // TODO We need to get the endpoint routes inside of initRoutes
    (0, _routes.initRoutes)(router, config, ((_plugins$encryptedSav = plugins.encryptedSavedObjects) === null || _plugins$encryptedSav === void 0 ? void 0 : _plugins$encryptedSav.canEncrypt) === true, plugins.security, this.telemetryEventsSender, plugins.ml, ruleDataService, logger, ruleDataClient, core.getStartServices, securityRuleTypeOptions, previewRuleDataClient, this.telemetryReceiver, this.isServerless, core.docLinks, this.endpointContext);
    (0, _metadata2.registerEndpointRoutes)(router, this.endpointContext);
    (0, _suggestions.registerEndpointSuggestionsRoutes)(router, plugins.unifiedSearch.autocomplete.getInitializerContextConfig().create(), this.endpointContext);
    (0, _limited_concurrency.registerLimitedConcurrencyRoutes)(core);
    (0, _policy.registerPolicyRoutes)(router, this.endpointContext);
    (0, _protection_updates_note.registerProtectionUpdatesNoteRoutes)(router, this.endpointContext);
    (0, _actions.registerActionRoutes)(router, this.endpointContext, ((_plugins$encryptedSav2 = plugins.encryptedSavedObjects) === null || _plugins$encryptedSav2 === void 0 ? void 0 : _plugins$encryptedSav2.canEncrypt) === true);
    (0, _agent.registerAgentRoutes)(router, this.endpointContext);
    if (plugins.alerting != null) {
      const ruleNotificationType = (0, _rule_actions_legacy.legacyRulesNotificationRuleType)({
        logger
      });
      if ((0, _rule_actions_legacy.isLegacyNotificationRuleExecutor)(ruleNotificationType)) {
        plugins.alerting.registerType(ruleNotificationType);
      }
    }
    const exceptionListsSetupEnabled = () => {
      return plugins.taskManager && plugins.lists;
    };
    if (exceptionListsSetupEnabled()) {
      this.lists = plugins.lists;
      this.manifestTask = new _artifacts.ManifestTask({
        endpointAppContext: this.endpointContext,
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        taskManager: plugins.taskManager
      });
    }
    if (plugins.taskManager) {
      this.completeExternalResponseActionsTask.setup({
        taskManager: plugins.taskManager
      });
    }
    core.getStartServices().then(async ([coreStart, depsStart]) => {
      var _depsStart$spaces, _depsStart$spaces$spa, _depsStart$spaces2, _depsStart$spaces2$sp;
      appClientFactory.setup({
        getSpaceId: (_depsStart$spaces = depsStart.spaces) === null || _depsStart$spaces === void 0 ? void 0 : (_depsStart$spaces$spa = _depsStart$spaces.spacesService) === null || _depsStart$spaces$spa === void 0 ? void 0 : _depsStart$spaces$spa.getSpaceId,
        config,
        kibanaVersion: pluginContext.env.packageInfo.version,
        kibanaBranch: pluginContext.env.packageInfo.branch,
        buildFlavor: pluginContext.env.packageInfo.buildFlavor
      });
      const endpointFieldsStrategy = (0, _endpoint_fields.endpointFieldsProvider)(this.endpointAppContextService, depsStart.data.indexPatterns);
      plugins.data.search.registerSearchStrategy(_constants2.ENDPOINT_FIELDS_SEARCH_STRATEGY, endpointFieldsStrategy);
      const endpointPackagePoliciesStatsStrategy = (0, _endpoint_package_policies_stats.endpointPackagePoliciesStatsSearchStrategyProvider)(this.endpointAppContextService);
      plugins.data.search.registerSearchStrategy(_constants2.ENDPOINT_PACKAGE_POLICIES_STATS_STRATEGY, endpointPackagePoliciesStatsStrategy);
      const securitySolutionSearchStrategy = (0, _security_solution.securitySolutionSearchStrategyProvider)(depsStart.data, this.endpointContext, (_depsStart$spaces2 = depsStart.spaces) === null || _depsStart$spaces2 === void 0 ? void 0 : (_depsStart$spaces2$sp = _depsStart$spaces2.spacesService) === null || _depsStart$spaces2$sp === void 0 ? void 0 : _depsStart$spaces2$sp.getSpaceId, ruleDataClient);
      plugins.data.search.registerSearchStrategy('securitySolutionSearchStrategy', securitySolutionSearchStrategy);
      const endpointSearchStrategy = (0, _endpoint.endpointSearchStrategyProvider)(depsStart.data, this.endpointContext);
      plugins.data.search.registerSearchStrategy(_constants2.ENDPOINT_SEARCH_STRATEGY, endpointSearchStrategy);
      const threatIntelligenceSearchStrategy = (0, _search_strategy.threatIntelligenceSearchStrategyProvider)(depsStart.data);
      plugins.data.search.registerSearchStrategy(_constants3.THREAT_INTELLIGENCE_SEARCH_STRATEGY_NAME, threatIntelligenceSearchStrategy);
      plugins.cases.attachmentFramework.registerExternalReference({
        id: _constants3.CASE_ATTACHMENT_TYPE_ID
      });
      this.siemMigrationsService.setup({
        esClusterClient: coreStart.elasticsearch.client
      });
    }).catch(() => {}); // it shouldn't reject, but just in case

    (0, _helpers.setIsElasticCloudDeployment)((_plugins$cloud$isClou = plugins.cloud.isCloudEnabled) !== null && _plugins$cloud$isClou !== void 0 ? _plugins$cloud$isClou : false);
    this.asyncTelemetryEventsSender.setup(_async_sender.DEFAULT_RETRY_CONFIG, _async_sender.DEFAULT_QUEUE_CONFIG, this.telemetryReceiver, plugins.telemetry, this.telemetryUsageCounter, core.analytics);
    this.telemetryEventsSender.setup(this.telemetryReceiver, plugins.telemetry, plugins.taskManager, this.telemetryUsageCounter, this.asyncTelemetryEventsSender);
    this.checkMetadataTransformsTask = new _metadata.CheckMetadataTransformsTask({
      endpointAppContext: this.endpointContext,
      core,
      // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
      taskManager: plugins.taskManager
    });
    _feature_usage.featureUsageService.setup(plugins.licensing);
    _services.securityWorkflowInsightsService.setup({
      kibanaVersion: pluginContext.env.packageInfo.version,
      logger: this.logger,
      endpointContext: this.endpointContext.service
    });
    if (plugins.taskManager) {
      this.healthDiagnosticService.setup({
        taskManager: plugins.taskManager
      });
    } else {
      this.logger.warn('Task Manager not available, health diagnostic task not registered.');
    }
    return {
      setProductFeaturesConfigurator: productFeaturesService.setProductFeaturesConfigurator.bind(productFeaturesService),
      experimentalFeatures: {
        ...config.experimentalFeatures
      }
    };
  }
  start(core, plugins) {
    var _plugins$fleet, _this$lists, _plugins$spaces, _this$config$telemetr, _this$config$cdn, _this$config$cdn2, _plugins$fleet2;
    const {
      config,
      logger,
      productFeaturesService
    } = this;
    this.ruleMonitoringService.start(core, plugins);
    const savedObjectsClient = new _server.SavedObjectsClient(core.savedObjects.createInternalRepository([_artifacts.ManifestConstants.SAVED_OBJECT_TYPE, _artifacts.ManifestConstants.UNIFIED_SAVED_OBJECT_TYPE]));
    const registerIngestCallback = (_plugins$fleet = plugins.fleet) === null || _plugins$fleet === void 0 ? void 0 : _plugins$fleet.registerExternalCallback;
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const exceptionListClient = this.lists.getExceptionListClient(savedObjectsClient, 'kibana',
    // execution of Lists plugin server extension points callbacks should be turned off
    // here because most of the uses of this client will be in contexts where some endpoint
    // validations (specifically those around authz) can not be done (due ot the lack of a `KibanaRequest`
    // from where authz can be derived)
    false);
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    const fleetStartServices = plugins.fleet;
    const {
      packageService
    } = fleetStartServices;
    this.licensing$ = plugins.licensing.license$;
    this.telemetryConfigProvider.start(plugins.telemetry.isOptedIn$);

    // Assistant Tool and Feature Registration
    const filteredTools = config.experimentalFeatures.riskScoreAssistantToolDisabled ? _tools.assistantTools.filter(({
      id
    }) => id !== _entity_risk_score.ENTITY_RISK_SCORE_TOOL_ID) : _tools.assistantTools;
    plugins.elasticAssistant.registerTools(_constants.APP_UI_ID, filteredTools);
    const features = {
      assistantModelEvaluation: config.experimentalFeatures.assistantModelEvaluation,
      defendInsightsPolicyResponseFailure: config.experimentalFeatures.defendInsightsPolicyResponseFailure
    };
    plugins.elasticAssistant.registerFeatures(_constants.APP_UI_ID, features);
    plugins.elasticAssistant.registerFeatures('management', features);
    const manifestManager = new _services.ManifestManager({
      savedObjectsClientFactory: new _saved_objects.SavedObjectsClientFactory(core.savedObjects, core.http),
      savedObjectsClient,
      exceptionListClient,
      artifactClient: new _services.EndpointArtifactClient(fleetStartServices.createArtifactsClient('endpoint')),
      packagePolicyService: fleetStartServices.packagePolicyService,
      logger: this.pluginContext.logger.get('ManifestManager'),
      experimentalFeatures: config.experimentalFeatures,
      packagerTaskPackagePolicyUpdateBatchSize: config.packagerTaskPackagePolicyUpdateBatchSize,
      esClient: core.elasticsearch.client.asInternalUser,
      productFeaturesService,
      licenseService: _license.licenseService
    });
    this.endpointAppContextService.start({
      fleetStartServices,
      security: core.security,
      alerting: plugins.alerting,
      config,
      cases: plugins.cases,
      manifestManager,
      licenseService: _license.licenseService,
      telemetryConfigProvider: this.telemetryConfigProvider,
      exceptionListsClient: exceptionListClient,
      registerListsServerExtension: (_this$lists = this.lists) === null || _this$lists === void 0 ? void 0 : _this$lists.registerExtension,
      featureUsageService: _feature_usage.featureUsageService,
      experimentalFeatures: config.experimentalFeatures,
      esClient: core.elasticsearch.client.asInternalUser,
      productFeaturesService,
      savedObjectsServiceStart: core.savedObjects,
      connectorActions: plugins.actions,
      spacesService: (_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.spacesService
    });
    if (this.lists && plugins.taskManager && plugins.fleet) {
      // Exceptions, Artifacts and Manifests start
      const taskManager = plugins.taskManager;
      plugins.fleet.fleetSetupCompleted().then(async () => {
        logger.info('Dependent plugin setup complete');
        if (this.manifestTask) {
          logger.info('Starting ManifestTask');
          await this.manifestTask.start({
            taskManager
          });
        } else {
          logger.error(new Error('User artifacts task not available.'));
        }
        const fleetServices = this.endpointAppContextService.getInternalFleetServices();
        await (0, _turn_off_policy_protections.turnOffPolicyProtectionsIfNotSupported)(core.elasticsearch.client.asInternalUser, fleetServices, productFeaturesService, logger);
        await (0, _turn_off_agent_policy_features.turnOffAgentPolicyFeatures)(fleetServices, productFeaturesService, logger);

        // Ensure policies have backing DOT indices (We don't need to `await` this.
        // It can run in the background)
        (0, _ensure_indices_exists_for_policies.ensureIndicesExistsForPolicies)(this.endpointAppContextService).catch(() => {});

        // Migrate endpoint data if space awareness is enabled
        // (We don't need to `await` this. It can run in the background)
        (0, _space_awareness_migration.migrateEndpointDataToSupportSpaces)(this.endpointAppContextService).catch(e => {
          logger.error(e);
        });
      }).catch(() => {});

      // License related start
      _license.licenseService.start(this.licensing$);
      _feature_usage.featureUsageService.start(plugins.licensing);
      this.policyWatcher = new _license_watch.PolicyWatcher(this.endpointAppContextService);
      this.policyWatcher.start(_license.licenseService);
      this.telemetryWatcher = new _telemetry_watch.TelemetryConfigWatcher(plugins.fleet.packagePolicyService, core.elasticsearch, this.endpointAppContextService);
      this.telemetryWatcher.start(this.telemetryConfigProvider);
    }
    if (plugins.taskManager) {
      this.completeExternalResponseActionsTask.start({
        taskManager: plugins.taskManager,
        esClient: core.elasticsearch.client.asInternalUser
      }).catch(() => {}); // it shouldn't refuse, but just in case
    }
    let queryConfig;
    if (((_this$config$telemetr = this.config.telemetry) === null || _this$config$telemetr === void 0 ? void 0 : _this$config$telemetr.queryConfig) !== undefined) {
      var _this$config$telemetr2, _this$config$telemetr3, _this$config$telemetr4;
      queryConfig = {
        pageSize: (_this$config$telemetr2 = this.config.telemetry.queryConfig.pageSize) !== null && _this$config$telemetr2 !== void 0 ? _this$config$telemetr2 : 500,
        maxResponseSize: (_this$config$telemetr3 = this.config.telemetry.queryConfig.maxResponseSize) !== null && _this$config$telemetr3 !== void 0 ? _this$config$telemetr3 : 10 * 1024 * 1024,
        // 10 MB
        maxCompressedResponseSize: (_this$config$telemetr4 = this.config.telemetry.queryConfig.maxCompressedResponseSize) !== null && _this$config$telemetr4 !== void 0 ? _this$config$telemetr4 : 8 * 1024 * 1024 // 8 MB
      };
    }
    this.telemetryReceiver.start(core, type => core.savedObjects.getIndexForType(type), _constants.DEFAULT_ALERTS_INDEX, this.endpointAppContextService, exceptionListClient, packageService, queryConfig).catch(() => {});
    if ((_this$config$cdn = this.config.cdn) !== null && _this$config$cdn !== void 0 && _this$config$cdn.url && (_this$config$cdn2 = this.config.cdn) !== null && _this$config$cdn2 !== void 0 && _this$config$cdn2.publicKey) {
      const cdnConfig = {
        url: this.config.cdn.url,
        pubKey: this.config.cdn.publicKey
      };
      this.logger.info('Starting artifact service with custom CDN config');
      _artifact.artifactService.start(this.telemetryReceiver, cdnConfig).catch(() => {});
    } else {
      this.logger.info('Starting artifact service with default CDN config');
      _artifact.artifactService.start(this.telemetryReceiver).catch(() => {});
    }
    this.asyncTelemetryEventsSender.start(plugins.telemetry);
    this.telemetryEventsSender.start(plugins.telemetry, plugins.taskManager, this.telemetryReceiver);
    _services.securityWorkflowInsightsService.start({
      esClient: core.elasticsearch.client.asInternalUser,
      registerDefendInsightsCallback: plugins.elasticAssistant.registerCallback
    }).catch(() => {});
    const endpointPkgInstallationPromise = this.endpointContext.service.getInternalFleetServices().packages.getInstallation(_common2.FLEET_ENDPOINT_PACKAGE);
    Promise.all([endpointPkgInstallationPromise, (_plugins$fleet2 = plugins.fleet) === null || _plugins$fleet2 === void 0 ? void 0 : _plugins$fleet2.fleetSetupCompleted()]).then(async ([endpointPkgInstallation]) => {
      if (plugins.taskManager) {
        var _this$checkMetadataTr;
        if (endpointPkgInstallation !== null && endpointPkgInstallation !== void 0 && endpointPkgInstallation.version && (0, _package_v.isEndpointPackageV2)(endpointPkgInstallation.version)) {
          return;
        }
        await ((_this$checkMetadataTr = this.checkMetadataTransformsTask) === null || _this$checkMetadataTr === void 0 ? void 0 : _this$checkMetadataTr.start({
          taskManager: plugins.taskManager
        }));
      }
    }).catch(() => {}); // it shouldn't reject, but just in case

    if (registerIngestCallback) {
      registerIngestCallback('packagePolicyCreate', async packagePolicy => {
        await (0, _security_integrations.getCriblPackagePolicyPostCreateOrUpdateCallback)(core.elasticsearch.client.asInternalUser, packagePolicy, this.logger);
        return packagePolicy;
      });
      registerIngestCallback('packagePolicyUpdate', async packagePolicy => {
        await (0, _security_integrations.getCriblPackagePolicyPostCreateOrUpdateCallback)(core.elasticsearch.client.asInternalUser, packagePolicy, this.logger);
        return packagePolicy;
      });
    }
    if (plugins.taskManager) {
      const serviceStart = {
        taskManager: plugins.taskManager,
        esClient: core.elasticsearch.client.asInternalUser,
        analytics: core.analytics,
        receiver: this.telemetryReceiver
      };
      this.healthDiagnosticService.start(serviceStart).catch(e => {
        this.logger.warn('Error starting health diagnostic task', {
          error: e.message
        });
      });
    } else {
      this.logger.warn('Task Manager not available, health diagnostic task not started.');
    }
    return {};
  }
  stop() {
    var _this$policyWatcher, _this$telemetryWatche;
    this.logger.debug('Stopping plugin');
    this.asyncTelemetryEventsSender.stop().catch(() => {});
    this.telemetryEventsSender.stop();
    this.endpointAppContextService.stop();
    (_this$policyWatcher = this.policyWatcher) === null || _this$policyWatcher === void 0 ? void 0 : _this$policyWatcher.stop();
    (_this$telemetryWatche = this.telemetryWatcher) === null || _this$telemetryWatche === void 0 ? void 0 : _this$telemetryWatche.stop();
    this.completeExternalResponseActionsTask.stop().catch(() => {});
    this.siemMigrationsService.stop();
    _services.securityWorkflowInsightsService.stop();
    _license.licenseService.stop();
  }
}
exports.Plugin = Plugin;