"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNFlowEdges = exports.getQueryOrder = void 0;
var _fp = require("lodash/fp");
var _search_strategy = require("../../../../../../common/search_strategy");
var _helpers = require("../helpers");
var _format_response_object_values = require("../../../../helpers/format_response_object_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTopNFlowEdges = (response, options) => formatTopNFlowEdges((0, _fp.getOr)([], `aggregations.${options.flowTarget}.buckets`, response.rawResponse), options.flowTarget);
exports.getTopNFlowEdges = getTopNFlowEdges;
const formatTopNFlowEdges = (buckets, flowTarget) => buckets.map(bucket => ({
  node: {
    _id: bucket.key,
    [flowTarget]: {
      domain: bucket.domain.buckets.map(bucketDomain => bucketDomain.key),
      ip: bucket.key,
      location: getGeoItem(bucket, flowTarget),
      autonomous_system: getAsItem(bucket),
      flows: (0, _fp.getOr)(0, 'flows.value', bucket),
      [`${(0, _helpers.getOppositeField)(flowTarget)}_ips`]: (0, _fp.getOr)(0, `${(0, _helpers.getOppositeField)(flowTarget)}_ips.value`, bucket)
    },
    network: {
      bytes_in: (0, _fp.getOr)(0, 'bytes_in.value', bucket),
      bytes_out: (0, _fp.getOr)(0, 'bytes_out.value', bucket)
    }
  },
  cursor: {
    value: bucket.key,
    tiebreaker: null
  }
}));
const getGeoItem = (result, flowTarget) => result.location.top_geo.hits.hits.length > 0 && result.location.top_geo.hits.hits[0].fields ? {
  geo: (0, _format_response_object_values.formatResponseObjectValues)((0, _fp.getOr)('', `${flowTarget}.geo`, (0, _format_response_object_values.unflattenObject)((0, _format_response_object_values.transformLocationFields)((0, _fp.getOr)({}, `location.top_geo.hits.hits[0].fields`, result))))),
  flowTarget
} : null;
const getAsItem = result => result.autonomous_system.top_as.hits.hits.length > 0 && result.autonomous_system.top_as.hits.hits[0].fields ? {
  number: (0, _fp.getOr)(null, `autonomous_system.top_as.hits.hits[0].fields['${Object.keys(result.autonomous_system.top_as.hits.hits[0].fields)[0].split('.as.')[0]}.as.number'][0]`, result),
  name: (0, _fp.getOr)('', `autonomous_system.top_as.hits.hits[0].fields['${Object.keys(result.autonomous_system.top_as.hits.hits[0].fields)[0].split('.as')[0]}.as.organization.name'][0]`, result)
} : null;
const getQueryOrder = networkTopNFlowSortField => {
  if (networkTopNFlowSortField.field === _search_strategy.NetworkTopTablesFields.bytes_in) {
    return {
      bytes_in: networkTopNFlowSortField.direction
    };
  } else if (networkTopNFlowSortField.field === _search_strategy.NetworkTopTablesFields.bytes_out) {
    return {
      bytes_out: networkTopNFlowSortField.direction
    };
  } else if (networkTopNFlowSortField.field === _search_strategy.NetworkTopTablesFields.flows) {
    return {
      flows: networkTopNFlowSortField.direction
    };
  } else if (networkTopNFlowSortField.field === _search_strategy.NetworkTopTablesFields.destination_ips) {
    return {
      destination_ips: networkTopNFlowSortField.direction
    };
  } else if (networkTopNFlowSortField.field === _search_strategy.NetworkTopTablesFields.source_ips) {
    return {
      source_ips: networkTopNFlowSortField.direction
    };
  } else {
    throw new Error(`Ordering on ${networkTopNFlowSortField.field} not currently supported`);
  }
};
exports.getQueryOrder = getQueryOrder;