"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateQueryUsage = updateQueryUsage;
var _get_notifications_enabled_disabled = require("./get_notifications_enabled_disabled");
var _update_alert_suppression_usage = require("./update_alert_suppression_usage");
var _update_response_actions_usage = require("./update_response_actions_usage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateQueryUsage({
  ruleType,
  usage,
  detectionRuleMetric
}) {
  const {
    legacyNotificationEnabled,
    legacyNotificationDisabled,
    notificationEnabled,
    notificationDisabled
  } = (0, _get_notifications_enabled_disabled.getNotificationsEnabledDisabled)(detectionRuleMetric);
  const commonQueryUsage = {
    enabled: detectionRuleMetric.enabled ? usage[ruleType].enabled + 1 : usage[ruleType].enabled,
    disabled: !detectionRuleMetric.enabled ? usage[ruleType].disabled + 1 : usage[ruleType].disabled,
    alerts: usage[ruleType].alerts + detectionRuleMetric.alert_count_daily,
    cases: usage[ruleType].cases + detectionRuleMetric.cases_count_total,
    legacy_notifications_enabled: legacyNotificationEnabled ? usage[ruleType].legacy_notifications_enabled + 1 : usage[ruleType].legacy_notifications_enabled,
    legacy_notifications_disabled: legacyNotificationDisabled ? usage[ruleType].legacy_notifications_disabled + 1 : usage[ruleType].legacy_notifications_disabled,
    notifications_enabled: notificationEnabled ? usage[ruleType].notifications_enabled + 1 : usage[ruleType].notifications_enabled,
    notifications_disabled: notificationDisabled ? usage[ruleType].notifications_disabled + 1 : usage[ruleType].notifications_disabled,
    legacy_investigation_fields: detectionRuleMetric.has_legacy_investigation_field ? usage[ruleType].legacy_investigation_fields + 1 : usage[ruleType].legacy_investigation_fields,
    alert_suppression: (0, _update_alert_suppression_usage.updateAlertSuppressionUsage)({
      usage: usage[ruleType],
      detectionRuleMetric
    }),
    has_exceptions: detectionRuleMetric.has_exceptions ? usage[ruleType].has_exceptions + 1 : usage[ruleType].has_exceptions,
    response_actions: (0, _update_response_actions_usage.updateResponseActionsUsage)({
      usage: usage[ruleType],
      detectionRuleMetric
    })
  };
  if (ruleType === 'threat_match' || ruleType === 'threat_match_custom') {
    return {
      ...commonQueryUsage,
      has_does_not_match_condition: detectionRuleMetric.has_does_not_match_condition ? usage[ruleType].has_does_not_match_condition + 1 : usage[ruleType].has_does_not_match_condition
    };
  }
  return commonQueryUsage;
}