"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upsellingSections = exports.upsellingPages = exports.upsellingMessages = void 0;
var _keys = require("@kbn/security-solution-features/keys");
var _common = require("@kbn/security-solution-plugin/common");
var _messages = require("@kbn/security-solution-upselling/messages");
var _react = _interopRequireDefault(require("react"));
var _cloud_security_posture = require("./sections/cloud_security_posture");
var _endpoint_management = require("./sections/endpoint_management");
var _use_product_type_by_pli = require("./hooks/use_product_type_by_pli");
var _lazy_upselling = require("./lazy_upselling");
var i18n = _interopRequireWildcard(require("./translations"));
var _automatic_import = require("./sections/automatic_import");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/security_solution_serverless/public/upselling/upsellings.tsx",
  _getProductTypeByPLI,
  _getProductTypeByPLI2,
  _getProductTypeByPLI3,
  _getProductTypeByPLI4,
  _getProductTypeByPLI5;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Upselling for entire pages, linked to a SecurityPageName
const upsellingPages = exports.upsellingPages = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  pageName: _common.SecurityPageName.entityAnalytics,
  pli: _keys.ProductFeatureKey.advancedInsights,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.EntityAnalyticsUpsellingPageLazy, {
    upgradeToLabel: entityAnalyticsProductType,
    upgradeMessage: i18n.UPGRADE_PRODUCT_MESSAGE(entityAnalyticsProductType),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  })
}, {
  pageName: _common.SecurityPageName.threatIntelligence,
  pli: _keys.ProductFeatureKey.threatIntelligence,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.ThreatIntelligencePaywallLazy, {
    requiredPLI: _keys.ProductFeatureKey.threatIntelligence,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  })
}, {
  pageName: _common.SecurityPageName.exceptions,
  pli: _keys.ProductFeatureKey.endpointExceptions,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.EndpointExceptionsDetailsUpsellingLazy, {
    requiredPLI: _keys.ProductFeatureKey.endpointExceptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  })
}, {
  pageName: _common.SecurityPageName.attackDiscovery,
  pli: _keys.ProductFeatureKey.attackDiscovery,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.AttackDiscoveryUpsellingPageLazy, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 22
    }
  })
}, {
  pageName: _common.SecurityPageName.siemMigrationsRules,
  pli: _keys.ProductFeatureKey.siemMigrations,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.SiemMigrationsTranslatedRulesUpsellPageLazy, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 22
    }
  })
}];
const entityAnalyticsProductType = (_getProductTypeByPLI = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.ProductFeatureKey.advancedInsights)) !== null && _getProductTypeByPLI !== void 0 ? _getProductTypeByPLI : '';

// Upselling for sections, linked by arbitrary ids
const upsellingSections = exports.upsellingSections = [
// It is highly advisable to make use of lazy loaded components to minimize bundle size.
{
  id: 'osquery_automated_response_actions',
  pli: _keys.ProductFeatureKey.osqueryAutomatedResponseActions,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.OsqueryResponseActionsUpsellingSectionLazy, {
    requiredPLI: _keys.ProductFeatureKey.osqueryAutomatedResponseActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  })
}, {
  id: 'endpoint_agent_tamper_protection',
  pli: _keys.ProductFeatureKey.endpointAgentTamperProtection,
  component: _endpoint_management.EndpointAgentTamperProtectionLazy
}, {
  id: 'endpointPolicyProtections',
  pli: _keys.ProductFeatureKey.endpointPolicyProtections,
  component: _endpoint_management.EndpointPolicyProtectionsLazy
}, {
  id: 'endpoint_custom_notification',
  pli: _keys.ProductFeatureKey.endpointCustomNotification,
  component: _endpoint_management.EndpointCustomNotificationLazy
}, {
  id: 'ruleDetailsEndpointExceptions',
  pli: _keys.ProductFeatureKey.endpointExceptions,
  component: _endpoint_management.RuleDetailsEndpointExceptionsLazy
}, {
  id: 'endpoint_device_control',
  pli: _keys.ProductFeatureKey.endpointTrustedDevices,
  component: _endpoint_management.EndpointDeviceControlLazy
}, {
  id: 'endpoint_protection_updates',
  pli: _keys.ProductFeatureKey.endpointProtectionUpdates,
  component: _endpoint_management.EndpointProtectionUpdatesLazy
}, {
  id: 'cloud_security_posture_integration_installation',
  pli: _keys.ProductFeatureKey.cloudSecurityPosture,
  component: _cloud_security_posture.CloudSecurityPostureIntegrationPliBlockLazy
}, {
  id: 'entity_analytics_panel',
  pli: _keys.ProductFeatureKey.advancedInsights,
  component: () => /*#__PURE__*/_react.default.createElement(_lazy_upselling.EntityAnalyticsUpsellingSectionLazy, {
    upgradeToLabel: entityAnalyticsProductType,
    upgradeMessage: i18n.UPGRADE_PRODUCT_MESSAGE(entityAnalyticsProductType),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  })
}, {
  id: 'siem_migrations_start',
  pli: _keys.ProductFeatureKey.siemMigrations,
  component: _lazy_upselling.SiemMigrationsStartUpsellSectionLazy
}, {
  id: 'automatic_import',
  pli: _keys.ProductFeatureKey.automaticImport,
  component: () => /*#__PURE__*/_react.default.createElement(_automatic_import.AutomaticImportLazy, {
    requiredPLI: _keys.ProductFeatureKey.automaticImport,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 22
    }
  })
}];

// Upselling for sections, linked by arbitrary ids
const upsellingMessages = exports.upsellingMessages = [{
  id: 'investigation_guide',
  pli: _keys.ProductFeatureKey.investigationGuide,
  message: (0, _messages.UPGRADE_INVESTIGATION_GUIDE)((_getProductTypeByPLI2 = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.ProductFeatureKey.investigationGuide)) !== null && _getProductTypeByPLI2 !== void 0 ? _getProductTypeByPLI2 : '')
}, {
  id: 'investigation_guide_interactions',
  pli: _keys.ProductFeatureKey.investigationGuideInteractions,
  message: (0, _messages.UPGRADE_INVESTIGATION_GUIDE_INTERACTIONS)((_getProductTypeByPLI3 = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.ProductFeatureKey.investigationGuideInteractions)) !== null && _getProductTypeByPLI3 !== void 0 ? _getProductTypeByPLI3 : '')
}, {
  id: 'prebuilt_rule_customization',
  pli: _keys.ProductFeatureKey.prebuiltRuleCustomization,
  message: (0, _messages.PREBUILT_RULE_CUSTOMIZATION)((_getProductTypeByPLI4 = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.ProductFeatureKey.prebuiltRuleCustomization)) !== null && _getProductTypeByPLI4 !== void 0 ? _getProductTypeByPLI4 : '', 'feature tier')
}, {
  id: 'prebuilt_rule_customization_description',
  pli: _keys.ProductFeatureKey.prebuiltRuleCustomization,
  message: (0, _messages.PREBUILT_RULE_CUSTOMIZATION_DESCRIPTION)((_getProductTypeByPLI5 = (0, _use_product_type_by_pli.getProductTypeByPLI)(_keys.ProductFeatureKey.prebuiltRuleCustomization)) !== null && _getProductTypeByPLI5 !== void 0 ? _getProductTypeByPLI5 : '', 'feature tier')
}];