"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateTaskEither = exports.validateNonExact = exports.validateEither = exports.validate = void 0;
var _Either = require("fp-ts/Either");
var _pipeable = require("fp-ts/pipeable");
var _TaskEither = require("fp-ts/TaskEither");
var t = _interopRequireWildcard(require("io-ts"));
var _exact_check = require("../exact_check");
var _format_errors = require("../format_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const validate = (obj, schema) => {
  const decoded = schema.decode(obj);
  const checked = (0, _exact_check.exactCheck)(obj, decoded);
  if ((0, _Either.isLeft)(checked)) {
    return [null, (0, _format_errors.formatErrors)(checked.left).join(',')];
  } else {
    return [checked.right, null];
  }
};
exports.validate = validate;
const validateNonExact = (obj, schema) => {
  const decoded = schema.decode(obj);
  if ((0, _Either.isLeft)(decoded)) {
    return [null, (0, _format_errors.formatErrors)(decoded.left).join(',')];
  } else {
    return [decoded.right, null];
  }
};
exports.validateNonExact = validateNonExact;
const validateEither = (schema, obj) => (0, _pipeable.pipe)(obj, a => schema.validate(a, t.getDefaultContext(schema.asDecoder())), (0, _Either.mapLeft)(errors => new Error((0, _format_errors.formatErrors)(errors).join(','))));
exports.validateEither = validateEither;
const validateTaskEither = (schema, obj) => (0, _TaskEither.fromEither)(validateEither(schema, obj));
exports.validateTaskEither = validateTaskEither;