"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMvExpandFields = void 0;
var _esqlAst = require("@kbn/esql-ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMvExpandFields = query => {
  const {
    root
  } = (0, _esqlAst.parse)(query);
  const mvExpandCommands = root.commands.filter(command => command.name === 'mv_expand');
  return mvExpandCommands.reduce((acc, command) => {
    const argument = command.args[0];
    if ((0, _esqlAst.isColumn)(argument) && argument.name) {
      acc.push(argument.name);
    }
    return acc;
  }, []);
};
exports.getMvExpandFields = getMvExpandFields;