"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToInvestigatedAlert = exports.BUTTON_TEST_ID = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/security/plugins/session_view/public/components/back_to_investigated_alert/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BUTTON_TEST_ID = exports.BUTTON_TEST_ID = 'sessionView:backToInvestigatedAlert';

/**
 * Jump back to investigated alert button, should appear
 * when user scrolls the investigated event out of view.
 */
const BackToInvestigatedAlert = ({
  isDisplayedAbove = false,
  onClick
}) => {
  const styles = (0, _styles.useStyles)({
    isDisplayedAbove
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: (0, _react2.css)([styles.jumpBackBadge, styles.buttonStyle]),
    iconType: isDisplayedAbove ? 'arrowUp' : 'arrowDown',
    iconSide: "right",
    onClick: onClick,
    onClickAriaLabel: "Back to investigated alert",
    "data-test-subj": BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.sessionView.backToInvestigatedAlert",
    defaultMessage: "Back to investigated alert",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })));
};
exports.BackToInvestigatedAlert = BackToInvestigatedAlert;