"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _uiTheme = require("@kbn/ui-theme");
var _hooks = require("../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = ({
  isDisplayedAbove
}) => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      font
    } = euiTheme;
    const buttonStyle = {
      color: _uiTheme.euiLightVars.euiColorEmptyShade,
      backgroundColor: _uiTheme.euiLightVars.euiColorPrimaryText
    };
    const container = {
      position: 'absolute',
      height: size.xxxxl,
      width: '100%',
      pointerEvents: 'none',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    };
    const jumpBackBadge = {
      position: 'sticky',
      pointerEvents: 'auto',
      cursor: 'pointer',
      fontWeight: font.weight.regular
    };
    if (isDisplayedAbove) {
      container.top = 0;
      container.background = `linear-gradient(180deg, ${euiTheme.colors.lightestShade} 0%, transparent 100%)`;
    } else {
      container.bottom = 0;
      container.background = `linear-gradient(360deg, ${euiTheme.colors.lightestShade} 0%, transparent 100%)`;
    }
    return {
      container,
      jumpBackBadge,
      buttonStyle
    };
  }, [isDisplayedAbove, euiTheme]);
  return cached;
};
exports.useStyles = useStyles;