"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const tabSection = {
      padding: euiTheme.size.base
    };
    const accordion = {
      borderTop: euiTheme.border.thin,
      '&:last-child': {
        borderBottom: euiTheme.border.thin
      },
      dl: {
        paddingTop: '0px'
      },
      '&:only-child': {
        border: euiTheme.border.thin,
        borderRadius: euiTheme.border.radius.medium
      }
    };
    const accordionButton = {
      padding: euiTheme.size.base,
      fontWeight: euiTheme.font.weight.bold
    };
    return {
      accordion,
      accordionButton,
      tabSection
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;