"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShareTypeContext = exports.useShareContext = exports.ShareProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/share/public/components/context/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShareContext = /*#__PURE__*/(0, _react.createContext)(null);
const ShareProvider = ({
  shareContext,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(ShareContext.Provider, {
    value: shareContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 10
    }
  }, children);
};
exports.ShareProvider = ShareProvider;
const useShareContext = () => {
  const context = (0, _react.useContext)(ShareContext);
  if (!context) {
    throw new Error('Failed to call `useShareContext` because the context from ShareMenuProvider is missing. Ensure the component or React root is wrapped with ShareMenuProvider');
  }
  return context;
};
exports.useShareContext = useShareContext;
const useShareTypeContext = (shareType, groupId) => {
  var _objectTypeMeta$confi, _objectTypeMeta$confi2, _objectTypeMeta$confi3;
  const context = useShareContext();
  const {
    shareMenuItems,
    objectTypeMeta,
    ...rest
  } = context;

  // the integration share type can have multiple implementations
  const shareTypeImplementations = (shareType === 'integration' ? Array.prototype.filter : Array.prototype.find).call(shareMenuItems, item => item.shareType === shareType && (item === null || item === void 0 ? void 0 : item.groupId) === (groupId !== null && groupId !== void 0 ? groupId : item === null || item === void 0 ? void 0 : item.groupId));
  const shareTypeObjectMeta = {
    ...objectTypeMeta,
    // @ts-expect-error -- this is a workaround for the type system
    config: shareType === 'integration' ? groupId ? (_objectTypeMeta$confi = objectTypeMeta.config) === null || _objectTypeMeta$confi === void 0 ? void 0 : (_objectTypeMeta$confi2 = _objectTypeMeta$confi.integration) === null || _objectTypeMeta$confi2 === void 0 ? void 0 : _objectTypeMeta$confi2[groupId] : {} : (_objectTypeMeta$confi3 = objectTypeMeta.config) === null || _objectTypeMeta$confi3 === void 0 ? void 0 : _objectTypeMeta$confi3[shareType]
  };
  return {
    ...rest,
    objectTypeMeta: shareTypeObjectMeta,
    shareMenuItems: shareTypeImplementations
  };
};
exports.useShareTypeContext = useShareTypeContext;