"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasActiveModifierKey = exports.getClosestLink = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Returns true if any modifier key is active on the event, false otherwise.
 */
const hasActiveModifierKey = event => {
  return event.metaKey || event.altKey || event.ctrlKey || event.shiftKey;
};

/**
 * Returns the closest anchor (`<a>`) element in the element parents (self included) up
 * to the given container (excluded), or undefined if none is found.
 */
exports.hasActiveModifierKey = hasActiveModifierKey;
const getClosestLink = (element, container) => {
  let current = element;
  do {
    var _current, _current2;
    if (((_current = current) === null || _current === void 0 ? void 0 : _current.tagName.toLowerCase()) === 'a') {
      return current;
    }
    const parent = (_current2 = current) === null || _current2 === void 0 ? void 0 : _current2.parentElement;
    if (!parent || parent === document.body || parent === container) {
      break;
    }
    current = parent;
  } while (parent || parent !== document.body || parent !== container);
  return undefined;
};
exports.getClosestLink = getClosestLink;