"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BudgetConsumed = BudgetConsumed;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/burn_rate_rule_editor/budget_consumed.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function BudgetConsumed({
  onChange,
  initialBurnRate = 1,
  longLookbackWindowInHours,
  sloTimeWindowInHours,
  errors
}) {
  const [budgetConsumed, setBudgetConsumed] = (0, _react.useState)(initialBurnRate * longLookbackWindowInHours / sloTimeWindowInHours * 100);
  const [formattedValue, setFormattedValue] = (0, _react.useState)(budgetConsumed.toFixed(2));
  const hasError = errors !== undefined && errors.length > 0;
  const onBudgetConsumedChanged = event => {
    const value = Number(event.target.value);
    setBudgetConsumed(value);
    const burnRate = sloTimeWindowInHours * (value / 100 / longLookbackWindowInHours);
    onChange(burnRate);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.slo.rules.budgetConsumed.rowLabel', {
      defaultMessage: '% Budget consumed'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.slo.rules.budgetConsumed.tooltip', {
        defaultMessage: 'How much budget is consumed before the first alert is fired.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    })),
    fullWidth: true,
    isInvalid: hasError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: hasError,
    fullWidth: true,
    step: 0.01,
    min: 0.01,
    max: 100,
    value: formattedValue,
    onChange: event => {
      onBudgetConsumedChanged(event);
      setFormattedValue(event.target.value);
    },
    onBlur: event => {
      const value = event.target.value;
      setFormattedValue(Number(value).toFixed(2));
    },
    "data-test-subj": "budgetConsumed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
}