"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDeleteConfirmationModal = SloDeleteConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sloSchema = require("@kbn/slo-schema");
var _react = _interopRequireWildcard(require("react"));
var _use_delete_slo = require("../../../hooks/use_delete_slo");
var _use_delete_slo_instance = require("../../../hooks/use_delete_slo_instance");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/delete_confirmation_modal/slo_delete_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SloDeleteConfirmationModal({
  slo,
  onCancel,
  onConfirm
}) {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    mutate: deleteSlo
  } = (0, _use_delete_slo.useDeleteSlo)();
  const {
    mutate: deleteSloInstance
  } = (0, _use_delete_slo_instance.useDeleteSloInstance)();
  const {
    name,
    groupBy
  } = slo;
  const instanceId = 'instanceId' in slo && slo.instanceId !== _sloSchema.ALL_VALUE ? slo.instanceId : undefined;
  const hasGroupBy = [groupBy].flat().some(group => group !== _sloSchema.ALL_VALUE);
  const [isDeleteRollupDataChecked, toggleDeleteRollupDataSwitch] = (0, _react.useState)(false);
  const onDeleteRollupDataSwitchChange = () => toggleDeleteRollupDataSwitch(!isDeleteRollupDataChecked);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, hasGroupBy && instanceId ? getInstanceTitleLabel(name, instanceId) : getTitleLabel(name))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, hasGroupBy && instanceId ? /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: {
      marginBottom: '2rem'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.groupByDisclaimerText",
    defaultMessage: "This SLO is an instance of many SLO instances.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "popswitch",
    label: _i18n.i18n.translate('xpack.slo.deleteConfirmationModal.switchDeleteRollupData', {
      defaultMessage: 'Delete rollup data for this instance'
    }),
    checked: isDeleteRollupDataChecked,
    onChange: onDeleteRollupDataSwitchChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.descriptionText",
    defaultMessage: "You can't recover this SLO after deleting it.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilitySolutionSloDeleteModalCancelButton",
    onClick: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  })), hasGroupBy && instanceId && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilitySolutionSloDeleteModalConfirmButton",
    type: "submit",
    color: "danger",
    onClick: () => {
      deleteSloInstance({
        slo: {
          id: slo.id,
          instanceId,
          name: slo.name
        },
        excludeRollup: isDeleteRollupDataChecked === false
      });
      onConfirm();
    },
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.deleteInstanceButtonLabel",
    defaultMessage: "Delete this instance only",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "observabilitySolutionSloDeleteModalConfirmButton",
    type: "submit",
    color: "danger",
    onClick: () => {
      deleteSlo({
        id: slo.id,
        name: slo.name
      });
      onConfirm();
    },
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, hasGroupBy && instanceId ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.deleteAllButtonLabel",
    defaultMessage: "Delete SLO and all Instances",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.deleteConfirmationModal.deleteButtonLabel",
    defaultMessage: "Delete",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }))));
}
function getTitleLabel(name) {
  return _i18n.i18n.translate('xpack.slo.deleteConfirmationModal.title', {
    defaultMessage: 'Delete {name}?',
    values: {
      name
    }
  });
}
function getInstanceTitleLabel(name, instanceId) {
  return _i18n.i18n.translate('xpack.slo.deleteConfirmationModal.instanceTitle', {
    defaultMessage: 'Delete {name} [{instanceId}]?',
    values: {
      name,
      instanceId
    }
  });
}