"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEnableConfirmationModal = SloEnableConfirmationModal;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_enable_slo = require("../../../hooks/use_enable_slo");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/components/slo/enable_confirmation_modal/slo_enable_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SloEnableConfirmationModal({
  slo,
  onCancel,
  onConfirm
}) {
  const {
    mutate: enableSlo
  } = (0, _use_enable_slo.useEnableSlo)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "primary",
    "data-test-subj": "sloEnableConfirmationModal",
    title: _i18n.i18n.translate('xpack.slo.enableConfirmationModal.title', {
      defaultMessage: 'Enable {name}?',
      values: {
        name: slo.name
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.slo.enableConfirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.slo.enableConfirmationModal.enableButtonLabel', {
      defaultMessage: 'Enable'
    }),
    onCancel: onCancel,
    onConfirm: () => {
      enableSlo({
        id: slo.id,
        name: slo.name
      });
      onConfirm();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.slo.enableConfirmationModal.descriptionText', {
    defaultMessage: 'Enabling this SLO will generate the missing data since it was disabled.'
  }));
}