"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSloView = GroupSloView;
var _react = _interopRequireWildcard(require("react"));
var _group_view = require("../../../../pages/slos/components/grouped_slos/group_view");
var _build_kql_query = require("./helpers/build_kql_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/overview/group_view/group_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GroupSloView({
  view,
  groupBy = 'status',
  groups = [],
  kqlQuery = '',
  filters = [],
  reloadSubject
}) {
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  const combinedKqlQuery = (0, _build_kql_query.buildCombinedKqlQuery)({
    groups,
    groupBy,
    kqlQuery
  });
  (0, _react.useEffect)(() => {
    reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(() => {
      setLastRefreshTime(Date.now());
    });
    return () => {
      reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.unsubscribe();
    };
  }, [reloadSubject]);
  return /*#__PURE__*/_react.default.createElement(_group_view.GroupView, {
    view: view,
    groupBy: groupBy,
    groupsFilter: groups,
    kqlQuery: combinedKqlQuery,
    filters: filters,
    lastRefreshTime: lastRefreshTime,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
}