"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverviewEmbeddableFactory = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactQuery = require("@kbn/react-query");
var _react2 = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _presentationContainers = require("@kbn/presentation-containers");
var _plugin_context = require("../../../context/plugin_context");
var _constants = require("./constants");
var _group_view = require("./group_view/group_view");
var _slo_overview = require("./slo_overview");
var _slo_overview_grid = require("./slo_overview_grid");
var _slo_overview_open_configuration = require("./slo_overview_open_configuration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/embeddable/slo/overview/slo_embeddable_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getOverviewPanelTitle = () => _i18n.i18n.translate('xpack.slo.sloEmbeddable.displayName', {
  defaultMessage: 'SLO Overview'
});
const defaultSloEmbeddableState = {
  sloId: undefined,
  sloInstanceId: undefined,
  showAllGroupByInstances: undefined,
  overviewMode: undefined,
  groupFilters: undefined,
  remoteName: undefined
};
const getOverviewEmbeddableFactory = ({
  coreStart,
  pluginsStart,
  sloClient
}) => ({
  type: _constants.SLO_OVERVIEW_EMBEDDABLE_ID,
  buildEmbeddable: async ({
    initialState,
    finalizeApi,
    uuid,
    parentApi
  }) => {
    var _deps$embeddableEnhan, _dynamicActionsManage3;
    const deps = {
      ...coreStart,
      ...pluginsStart
    };
    const state = initialState.rawState;
    const dynamicActionsManager = (_deps$embeddableEnhan = deps.embeddableEnhanced) === null || _deps$embeddableEnhan === void 0 ? void 0 : _deps$embeddableEnhan.initializeEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), initialState);
    const maybeStopDynamicActions = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.startDynamicActions();
    const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
    const sloStateManager = (0, _presentationPublishing.initializeStateManager)(state, defaultSloEmbeddableState);
    const defaultTitle$ = new _rxjs.BehaviorSubject(getOverviewPanelTitle());
    const reload$ = new _rxjs.Subject();
    function serializeState() {
      var _dynamicActionsManage;
      const {
        rawState: dynamicActionsState,
        references: dynamicActionsReferences
      } = (_dynamicActionsManage = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.serializeState()) !== null && _dynamicActionsManage !== void 0 ? _dynamicActionsManage : {};
      return {
        rawState: {
          ...titleManager.getLatestState(),
          ...sloStateManager.getLatestState(),
          ...dynamicActionsState
        },
        references: dynamicActionsReferences !== null && dynamicActionsReferences !== void 0 ? dynamicActionsReferences : []
      };
    }
    const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
      uuid,
      parentApi,
      serializeState,
      anyStateChange$: (0, _rxjs.merge)(...(dynamicActionsManager ? [dynamicActionsManager.anyStateChange$] : []), titleManager.anyStateChange$, sloStateManager.anyStateChange$),
      getComparators: () => {
        var _dynamicActionsManage2;
        return {
          sloId: 'referenceEquality',
          sloInstanceId: 'referenceEquality',
          groupFilters: 'referenceEquality',
          showAllGroupByInstances: 'referenceEquality',
          remoteName: 'referenceEquality',
          overviewMode: 'referenceEquality',
          ..._presentationPublishing.titleComparators,
          ...((_dynamicActionsManage2 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.comparators) !== null && _dynamicActionsManage2 !== void 0 ? _dynamicActionsManage2 : {
            enhancements: 'skip'
          })
        };
      },
      onReset: lastSaved => {
        var _lastSaved$rawState;
        dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.reinitializeState((_lastSaved$rawState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState) !== null && _lastSaved$rawState !== void 0 ? _lastSaved$rawState : {});
        titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        sloStateManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
      }
    });
    const api = finalizeApi({
      ...unsavedChangesApi,
      ...titleManager.api,
      ...((_dynamicActionsManage3 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.api) !== null && _dynamicActionsManage3 !== void 0 ? _dynamicActionsManage3 : {}),
      ...sloStateManager.api,
      defaultTitle$,
      hideTitle$: titleManager.api.hidePanelTitles$,
      setHideTitle: titleManager.api.setHidePanelTitles,
      supportedTriggers: () => [],
      getTypeDisplayName: () => _i18n.i18n.translate('xpack.slo.editSloOverviewEmbeddableTitle.typeDisplayName', {
        defaultMessage: 'criteria'
      }),
      isEditingEnabled: () => api.getSloGroupOverviewConfig().overviewMode === 'groups',
      onEdit: async function onEdit() {
        try {
          const result = await (0, _slo_overview_open_configuration.openSloConfiguration)(coreStart, pluginsStart, sloClient, api.getSloGroupOverviewConfig());
          api.updateSloGroupOverviewConfig(result);
        } catch (e) {
          return Promise.reject();
        }
      },
      serializeState,
      getSloGroupOverviewConfig: () => {
        const {
          groupFilters,
          overviewMode
        } = sloStateManager.getLatestState();
        return {
          groupFilters,
          overviewMode
        };
      },
      updateSloGroupOverviewConfig: update => {
        sloStateManager.api.setGroupFilters(update.groupFilters);
      }
    });
    const fetchSubscription = (0, _presentationPublishing.fetch$)(api).pipe().subscribe(next => {
      reload$.next(next.isReload);
    });
    return {
      api,
      Component: () => {
        const [sloId, sloInstanceId, showAllGroupByInstances, overviewMode, groupFilters, remoteName] = (0, _presentationPublishing.useBatchedPublishingSubjects)(sloStateManager.api.sloId$, sloStateManager.api.sloInstanceId$, sloStateManager.api.showAllGroupByInstances$, sloStateManager.api.overviewMode$, sloStateManager.api.groupFilters$, sloStateManager.api.remoteName$);
        (0, _react2.useEffect)(() => {
          return () => {
            fetchSubscription.unsubscribe();
            maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
          };
        }, []);
        const renderOverview = () => {
          if (overviewMode === 'groups') {
            var _groupFilters$groupBy, _groupFilters$kqlQuer, _groupFilters$groups;
            const groupBy = (_groupFilters$groupBy = groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.groupBy) !== null && _groupFilters$groupBy !== void 0 ? _groupFilters$groupBy : 'status';
            const kqlQuery = (_groupFilters$kqlQuer = groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.kqlQuery) !== null && _groupFilters$kqlQuer !== void 0 ? _groupFilters$kqlQuer : '';
            const groups = (_groupFilters$groups = groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.groups) !== null && _groupFilters$groups !== void 0 ? _groupFilters$groups : [];
            return /*#__PURE__*/_react2.default.createElement("div", {
              css: ({
                euiTheme
              }) => (0, _react.css)`
                  width: 100%;
                  padding: ${euiTheme.size.xs} ${euiTheme.size.base};
                  overflow: scroll;

                  .euiAccordion__buttonContent {
                    min-width: ${euiTheme.base * 6}px;
                  }
                `,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 199,
                columnNumber: 15
              }
            }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
              "data-test-subj": "sloGroupOverviewPanel",
              "data-shared-item": "",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 210,
                columnNumber: 17
              }
            }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
              css: ({
                euiTheme
              }) => (0, _react.css)`
                      margin-top: ${euiTheme.base * 1.25}px;
                    `,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 211,
                columnNumber: 19
              }
            }, /*#__PURE__*/_react2.default.createElement(_group_view.GroupSloView, {
              view: "cardView",
              groupBy: groupBy,
              groups: groups,
              kqlQuery: kqlQuery,
              filters: groupFilters === null || groupFilters === void 0 ? void 0 : groupFilters.filters,
              reloadSubject: reload$,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 216,
                columnNumber: 21
              }
            }))));
          } else {
            return /*#__PURE__*/_react2.default.createElement(_slo_overview.SloOverview, {
              sloId: sloId,
              sloInstanceId: sloInstanceId,
              reloadSubject: reload$,
              showAllGroupByInstances: showAllGroupByInstances,
              remoteName: remoteName,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 230,
                columnNumber: 15
              }
            });
          }
        };
        const queryClient = new _reactQuery.QueryClient();
        return /*#__PURE__*/_react2.default.createElement(_common.EuiThemeProvider, {
          darkMode: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 244,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react2.default.createElement(_public.KibanaContextProvider, {
          services: deps,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 245,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react2.default.createElement(_plugin_context.PluginContext.Provider, {
          value: {
            observabilityRuleTypeRegistry: pluginsStart.observability.observabilityRuleTypeRegistry,
            ObservabilityPageTemplate: pluginsStart.observabilityShared.navigation.PageTemplate,
            sloClient
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 246,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react2.default.createElement(_reactQuery.QueryClientProvider, {
          client: queryClient,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 255,
            columnNumber: 17
          }
        }, showAllGroupByInstances ? /*#__PURE__*/_react2.default.createElement(_slo_overview_grid.SloCardChartList, {
          sloId: sloId,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 256,
            columnNumber: 46
          }
        }) : renderOverview()))));
      }
    };
  }
});
exports.getOverviewEmbeddableFactory = getOverviewEmbeddableFactory;