"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSloHealth = useFetchSloHealth;
var _sloSchema = require("@kbn/slo-schema");
var _reactQuery = require("@kbn/react-query");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSloHealth({
  list,
  page,
  perPage,
  statusFilter = 'unhealthy'
}) {
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const payload = list ? list.map(slo => {
    var _slo$instanceId;
    return {
      sloId: slo.id,
      sloInstanceId: (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE
    };
  }) : [];
  const {
    isLoading,
    isError,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.sloKeys.health(payload),
    queryFn: async ({
      signal
    }) => {
      try {
        return await sloClient.fetch('POST /internal/observability/slos/_health', {
          params: {
            body: {
              list: payload,
              page,
              perPage,
              statusFilter
            }
          },
          signal
        });
      } catch (error) {
        // ignore error
      }
    },
    enabled: true,
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isError
  };
}