"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchSyntheticsSuggestions = useFetchSyntheticsSuggestions;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchSyntheticsSuggestions({
  filters,
  fieldName,
  search
}) {
  var _data$fieldName;
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    locations,
    monitorIds,
    tags,
    projects
  } = filters || {};
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchSyntheticsSuggestions', locations, monitorIds, tags, projects, search],
    queryFn: async ({
      signal
    }) => {
      try {
        const suggestions = await http.get('/internal/synthetics/suggestions', {
          query: {
            locations: locations || [],
            monitorQueryIds: monitorIds || [],
            tags: tags || [],
            projects: projects || [],
            query: search
          },
          signal
        });
        return suggestions;
      } catch (error) {
        // ignore error
      }
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    suggestions: isInitialLoading ? [] : (_data$fieldName = data === null || data === void 0 ? void 0 : data[fieldName]) !== null && _data$fieldName !== void 0 ? _data$fieldName : [],
    isLoading: isInitialLoading || isLoading || isRefetching,
    isSuccess,
    isError
  };
}