"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuerySearchBar = QuerySearchBar;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/observability-shared-plugin/common");
var _sloSchema = require("@kbn/slo-schema");
var _react2 = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_kibana = require("../../../../hooks/use_kibana");
var _optional_text = require("./optional_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/slo/public/pages/slo_edit/components/common/query_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function QuerySearchBar({
  name,
  label,
  dataView,
  required,
  tooltip,
  dataTestSubj,
  placeholder,
  isFlyoutOpen = false,
  range,
  setRange
}) {
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    },
    data: dataService
  } = (0, _use_kibana.useKibana)().services;
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    defaultValue: "",
    name: name,
    control: control,
    rules: {
      required: Boolean(required) && Boolean(dataView),
      validate: value => {
        try {
          if (!dataView) return;
          if (typeof value === 'string') {
            const ast = (0, _esQuery.fromKueryExpression)(value);
            (0, _esQuery.toElasticsearchQuery)(ast, dataView);
          } else if (_sloSchema.kqlWithFiltersSchema.is(value)) {
            const ast = (0, _esQuery.fromKueryExpression)(value.kqlQuery);
            (0, _esQuery.toElasticsearchQuery)(ast, dataView);
          }
        } catch (e) {
          return e.message;
        }
      }
    },
    render: ({
      field,
      fieldState
    }) => {
      var _fieldState$error, _range$from, _range$to, _field$value$filters2, _field$value3;
      const handleQueryChange = (value, nRange) => {
        if (isFlyoutOpen && nRange) {
          setRange === null || setRange === void 0 ? void 0 : setRange(nRange);
        }
        if (_sloSchema.kqlQuerySchema.is(field.value)) {
          field.onChange(String(value === null || value === void 0 ? void 0 : value.query));
        } else {
          var _field$value$filters, _field$value;
          field.onChange({
            filters: (_field$value$filters = (_field$value = field.value) === null || _field$value === void 0 ? void 0 : _field$value.filters) !== null && _field$value$filters !== void 0 ? _field$value$filters : [],
            kqlQuery: String(value === null || value === void 0 ? void 0 : value.query)
          });
        }
      };
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
        label: !!tooltip ? /*#__PURE__*/_react2.default.createElement("span", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 89,
            columnNumber: 17
          }
        }, label, " ", tooltip) : label,
        labelAppend: !required ? /*#__PURE__*/_react2.default.createElement(_optional_text.OptionalText, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 38
          }
        }) : undefined,
        isInvalid: fieldState.invalid,
        error: (_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message,
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react2.default.createElement("div", {
        css: (0, _react.css)`
                .uniSearchBar {
                  padding: 0;
                }
              `,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react2.default.createElement(SearchBar, {
        appName: _common.observabilityAppId,
        dataTestSubj: dataTestSubj,
        indexPatterns: dataView ? [dataView] : [],
        isDisabled: !dataView,
        placeholder: placeholder,
        query: {
          query: _sloSchema.kqlQuerySchema.is(field.value) ? String(field.value) : field.value.kqlQuery,
          language: 'kuery'
        }
        // we rely on submit button to submit the form when the flyout is open
        ,
        onQueryChange: isFlyoutOpen ? undefined : value => handleQueryChange(value.query, value.dateRange),
        onQuerySubmit: value => handleQueryChange(value.query, value.dateRange),
        onFiltersUpdated: filters => {
          const updatedFilters = filters.map(filter => {
            var _meta$alias;
            const {
              $state,
              meta,
              ...rest
            } = filter;
            const query = filter !== null && filter !== void 0 && filter.query ? {
              ...filter.query
            } : {
              ...rest
            };
            return {
              meta: {
                ...meta,
                alias: (_meta$alias = meta === null || meta === void 0 ? void 0 : meta.alias) !== null && _meta$alias !== void 0 ? _meta$alias : JSON.stringify(query)
              },
              query
            };
          });
          dataService.query.filterManager.setFilters(updatedFilters);
          if (_sloSchema.kqlQuerySchema.is(field.value)) {
            field.onChange({
              filters: updatedFilters,
              kqlQuery: field.value
            });
          } else {
            var _field$value$kqlQuery, _field$value2;
            field.onChange({
              kqlQuery: (_field$value$kqlQuery = (_field$value2 = field.value) === null || _field$value2 === void 0 ? void 0 : _field$value2.kqlQuery) !== null && _field$value$kqlQuery !== void 0 ? _field$value$kqlQuery : '',
              filters: updatedFilters
            });
          }
        },
        onSavedQueryUpdated: savedQuery => {
          field.onChange({
            filters: savedQuery.attributes.filters,
            kqlQuery: String(savedQuery.attributes.query.query)
          });
        },
        dateRangeFrom: (_range$from = range === null || range === void 0 ? void 0 : range.from) !== null && _range$from !== void 0 ? _range$from : 'now-15m',
        dateRangeTo: (_range$to = range === null || range === void 0 ? void 0 : range.to) !== null && _range$to !== void 0 ? _range$to : 'now',
        onTimeRangeChange: nRange => {
          setRange === null || setRange === void 0 ? void 0 : setRange(nRange.dateRange);
        },
        showDatePicker: isFlyoutOpen,
        showSubmitButton: isFlyoutOpen,
        showQueryInput: true,
        disableQueryLanguageSwitcher: true,
        onClearSavedQuery: () => {},
        filters: _sloSchema.kqlQuerySchema.is(field.value) ? [] : (_field$value$filters2 = (_field$value3 = field.value) === null || _field$value3 === void 0 ? void 0 : _field$value3.filters) !== null && _field$value$filters2 !== void 0 ? _field$value$filters2 : [],
        allowSavingQueries: true,
        showSavedQueryControls: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 15
        }
      })));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  });
}